# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from django.views.generic import TemplateView
from django.http import HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import (
    class_based_login_required, RULES_TYPES, getRulesForPeriod, getRulesData, buildRulesTable
)

LOGGER = logging.getLogger(__name__)


@class_based_login_required
class StatRulesView(TemplateView):
    template_name = "statrules.html"

    def _prepare_result(self, request, data):
        LOGGER.info(f"StatRulesView request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        self.route = data.get("route", "In")
        self.rules_par = data.get("rules", "")
        self.param = {
            'num': 0 if not data.get("num") or data.get("num") == 'undefined' else
                int(data.get("num", 0)),
            'period': 3 if not data.get("period") or data.get("period") == 'undefined' else
                int(data.get("period", 3)),
            'days_period': '' if not data.get("days_period") or data.get("days_period") == 'undefined'
                else data.get("days_period", ""),
            'sortorder1': 'weight' if not data.get("sortorder1") or
                data.get("sortorder1") == 'undefined' else data.get("sortorder1", "weight"),
            'sortorder2': 'weight' if not data.get("sortorder2") or
                data.get("sortorder2") == 'undefined' else data.get("sortorder2", "weight"),
            'sortorder3': 'weight' if not data.get("sortorder3") or
                data.get("sortorder3") == 'undefined' else data.get("sortorder3", "weight"),
            'choice': 1 if not data.get("fields_source") else int(data.get("fields_source", "1")),
            'max_rules_count': '' if not data.get("max_rules_count") else
                int(data.get("max_rules_count", 0)),
            'age_min': '' if not data.get('age_min') or data.get('age_min') == 'undefined' else
                int(data.get('age_min', 0)),
            'age_max': '' if not data.get('age_max') or data.get('age_max') == 'undefined' else
                int(data.get('age_max', 0)),
            'heavy_min': '' if not data.get('heavy_min') or data.get('heavy_min') == 'undefined' else
                float(data.get('heavy_min', 0)),
            'heavy_max': '' if not data.get('heavy_max') or data.get('heavy_max') == 'undefined'
                else float(data.get('heavy_max', 0)),
            'sp_min': '' if not data.get('percent_spam_min') or
                data.get('percent_spam_min') == 'undefined' else int(data.get('percent_spam_min', 0)),
            'sp_max': '' if not data.get('percent_spam_max') or
                data.get('percent_spam_max') == 'undefined' else int(data.get('percent_spam_max', 0)),
            'nopf_min': '' if not data.get('nopf_min') or data.get('nopf_min') == 'undefined' else
                int(data.get('nopf_min', 0)),
            'nopf_max': '' if not data.get('nopf_max') or data.get('nopf_max') == 'undefined' else
                int(data.get('nopf_max', 0)),
            'total_min': '' if not data.get('total_min') or data.get('total_min') == 'undefined' else
                int(data.get('total_min', 0)),
            'total_max': '' if not data.get('total_max') or data.get('total_max') == 'undefined' else
                int(data.get('total_max', 0)),
            'is_atomic': '' if not data.get('is_atomic') or data.get('is_atomic') == 'undefined' else
                data.get('is_atomic', ''),
            'cs_nopf_min': '' if not data.get('cmpl_spam_nopf_min') or
                data.get('cmpl_spam_nopf_min') == 'undefined' else int(data.get('cmpl_spam_nopf_min', 0)),
            'cs_nopf_max': '' if not data.get('cmpl_spam_nopf_max') or
                data.get('cmpl_spam_nopf_max') == 'undefined' else int(data.get('cmpl_spam_nopf_max', 0)),
            'ch_nopf_min': '' if not data.get('cmpl_ham_nopf_min') or
                data.get('cmpl_ham_nopf_min') == 'undefined' else int(data.get('cmpl_ham_nopf_min', 0)),
            'ch_nopf_max': '' if not data.get('cmpl_ham_nopf_max') or
                data.get('cmpl_ham_nopf_max') == 'undefined' else int(data.get('cmpl_ham_nopf_max', 0)),
            'cs_min': '' if not data.get('cmpl_spam_min') or
                data.get('cmpl_spam_min') == 'undefined' else int(data.get('cmpl_spam_min', 0)),
            'cs_max': '' if not data.get('cmpl_spam_max') or
                data.get('cmpl_spam_max') == 'undefined' else int(data.get('cmpl_spam_max', 0)),
            'ch_min': '' if not data.get('cmpl_ham_min') or
                data.get('cmpl_ham_min') == 'undefined' else int(data.get('cmpl_ham_min', 0)),
            'ch_max': '' if not data.get('cmpl_ham_max') or
                data.get('cmpl_ham_max') == 'undefined' else int(data.get('cmpl_ham_max', 0))
        }
        self.rules = {}
        if self.param['choice'] == 1 and self.rules_par:
            self.rules = getRulesForPeriod(
                self.route,
                {'rules': list(filter(
                    lambda r: not (r is None) and re.search(r'(?!^\d+$)^[A-Z0-9_]+$', r),
                    re.split(r'\s*[:,\s\n]+\s*', self.rules_par)))}
            )
        elif self.param['choice'] == 2:
            self.rules = getRulesForPeriod(
                self.route,
                {'age_min': self.param['age_min'], 'age_max': self.param['age_max']}
            )
        LOGGER.info(f"StatRulesView input rules: {self.rules}")
        self.ruledata = getRulesData(self.route, self.rules, self.param) if len(self.rules) > 0 else {}
        self.all_count = len(self.ruledata.keys())
        self.rul_count = len(list(filter(
            lambda r: self.ruledata[r]['type'] and self.ruledata[r]['type'] == 'rul',
            self.ruledata.keys())))
        self.dlv_count = len(list(filter(
            lambda r: self.ruledata[r]['type'] and self.ruledata[r]['type'] == 'dlv',
            self.ruledata.keys())))
        self.undef_count = self.all_count - self.rul_count - self.dlv_count
        self.table1 = buildRulesTable(
            f"Обычные правила ({self.rul_count} шт.):",
            'rul',
            self.param['sortorder1'],
            self.ruledata,
            self.route) \
                if self.rul_count > 0 else ''
        self.table2 = buildRulesTable(
            f"Рассылочные правила ({self.dlv_count} шт.):",
            'dlv',
            self.param['sortorder2'],
            self.ruledata,
            self.route) \
                if self.dlv_count > 0 else ''
        self.table3 = buildRulesTable(
            f"Правила, тип которых (обычные или рассылочные) не определён ({self.undef_count} шт.):",
            'unknown',
            self.param['sortorder3'],
            self.ruledata,
            self.route) \
                if self.undef_count > 0 else ''

    def get(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"StatRulesView GET request: {request}")
        self._prepare_result(request, request.GET)
        return super(StatRulesView, self).get(request, *args, **kwargs)

    def post(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"StatRulesView POST request: {request}")
        self._prepare_result(request, request.POST)
        return super(StatRulesView, self).get(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(StatRulesView, self).get_context_data(**kwargs)
        context["uri"] = self.uri
        context["RULES_TYPES"] = RULES_TYPES
        context["param"] = self.param
        context["route"] = self.route
        context["rules_par"] = self.rules_par
        context["rules"] = self.rules
        context["all_count"] = self.all_count
        context["rul_count"] = self.rul_count
        context["dlv_count"] = self.dlv_count
        context["undef_count"] = self.undef_count
        context["undef_count_mod_10"] = self.undef_count % 10
        context["table1"] = self.table1
        context["table2"] = self.table2
        context["table3"] = self.table3
        return context
