# coding: utf8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import unicode_literals
import re
import logging
from django.conf import settings
from django.views.generic import TemplateView
from django.http import HttpRequest, HttpResponse
from mail.so.spamstop.web.ui.web_tools.libs import class_based_login_required, MulcaGateClient, eFilter

LOGGER = logging.getLogger(__name__)


class spaceRepl:
    def __init__(self, spaceChar: str, replStr: str = '&nbsp;'):
        self.spaceChar = spaceChar
        self.replStr = replStr

    def __call__(self, matchObj):
        n = len(matchObj.group(1)) if matchObj else 0
        if self.spaceChar == '\t':
            n *= 8
        return self.replStr * n if n > 0 else ''


@class_based_login_required
class StidShowView(TemplateView):
    template_name = "stid_show.html"

    def setup(self, request: HttpRequest, *args, **kwargs) -> None:
        super(StidShowView, self).setup(request, *args, **kwargs)
        self.mulcaClient = MulcaGateClient()
        self.stid = ''
        self.queueid = ''
        self.msgid = ''
        self.uid = ''
        self.text = ''

    def dispatch(self, request, *args, **kwargs) -> HttpResponse:
        LOGGER.info(f"Request: {request}")
        self.uri = request.META['REQUEST_URI'] if 'REQUEST_URI' in request.META else ''
        self.proto = request.scheme
        self.uri = re.sub(r'/?[^/]+$', '', self.uri)
        if not self.uri.endswith('/'):
            self.uri += '/'
        if not self.uri.endswith(settings.CFG['root_url']):
            self.uri += settings.CFG['root_url']
        self.action = request.GET.get("action", "show")
        self.stid = request.GET.get("stid", "")
        self.uid = request.GET.get("uid", "")
        self.msgid = request.GET.get("msgid", "")
        if self.stid:
            self.text = self.mulcaClient.get(self.stid)
            if self.text:
                if re.match(r'^<?xml', self.text):
                    self.text = re.sub(r'^<?xml.*?</message>\s+', r'', self.text, re.S)
                m = re.search(r'Message-Id:\s+<(.+?)>', self.text, re.M | re.I)
                if m and m.group(1):
                    self.msgid = m.group(1)
                m = re.search(r'by .*?\.(?:mail|qloud-c)\.yandex.net\s+\([a-z-]+\/Yandex\)\s+with\s+E?SMTPS?A?\s+id\s+(\w{10,12}-\w{8,10})\b', self.text)
                if m and m.group(1):
                    self.queueid = m.group(1)
                self.text = eFilter(self.text)
                self.text = re.sub(r'^(\ +)', spaceRepl(' '), self.text, flags=re.M)
                self.text = re.sub(r'^(\t+)', spaceRepl('\t'), self.text, flags=re.M)
                self.text = self.text.replace('\r', '').replace('\n', '<br>')
        return super(StidShowView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(StidShowView, self).get_context_data(**kwargs)
        context["uri"] = self.uri
        context["stid"] = self.stid
        context["uid"] = self.uid
        context["msgid"] = self.msgid
        context["queueid"] = self.queueid
        context["text"] = self.text
        return context
