#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb, re
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
from datetime import datetime
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from db_utils import loadMongoDbCredentials, getMongoDB, getPGCredentials, getPGdb
from common import getUserInfo


# ----------------------- DB parameters -----------------------------
PG = {
    "host":    "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
    "port":    6432,
    "db":      "complaints",
    "user":    "cmpl"
}
CHUNK_SIZE = 10000

cmplSrc = {'wmi': 'Web', 'imap': 'IMAP', 'mobile': 'Mobile', 'otrs': 'OTRS', 'crm': 'CRM', 'furita': 'Furita', 'fastsrv': 'FastSrv', 'node_js': 'NodeJS', 'exchange': 'MSExchange', 'fblin': 'FBL'}
fooSrc = ['complaint on ham', 'complaint on spam', 'unsubscribe', 'move to another folder', 'set flag']

form = cgi.FieldStorage()
key, key_type, data = form.getfirst("key", ""), form.getfirst("key_type", ""), {}
uid, suid, login = form.getfirst("uid", ""), form.getfirst("suid", ""), form.getfirst("login", "")
host = "%s://%s/" % ('http' + ('s' if 'HTTPS' in os.environ else ''), os.environ['SERVER_NAME'])
if uid:
    key_type, key = 'uid', uid
elif suid:
    key_type, key = 'suid', suid
elif login:
    key_type, key = 'login', login

print "Content-type: text/html\r\n\r\n"

pg = {}
getPGCredentials(PG)
try:
    pg = getPGdb(PG)
except Exception, e:
    writelog("DB exception: %s" % str(e), True)
if key:
    cbAbuse, cbSource, abFilter = form.getlist('cb_abuse'), form.getlist('cb_source'), {}
    cbAbuseNeg, cbSourceNeg = set(range(len(fooSrc))) - set(map(int, cbAbuse)), set(cmplSrc.keys()) - set(cbSource)
    if key_type == "uid":
        uid, suid, login = getUserInfo(uid = key)
    elif key_type == "suid":
        uid, suid, login = getUserInfo(suid = key)
    elif key_type == "login":
        uid, suid, login = getUserInfo(login = key)
    if len(cbAbuse) != 0 and len(cbSource) != 0:
        if uid:
            abFilter["uid"] = "uid={0}".format(uid)
        elif suid:
            abFilter["suid"] = "suid={0}".format(suid)
        if len(cbAbuse) < len(cbAbuseNeg):
            abFilter['foo'] = 'foo IN (%s)' % ','.join(map(str, cbAbuse))
        elif len(cbAbuseNeg) > 0:
            abFilter['foo'] = 'foo NOT IN (%s)' % ','.join(map(str, cbAbuseNeg))
        if len(cbSource) < len(cbSourceNeg):
            abFilter['source'] = ' AND '.join(map(lambda s: "source LIKE '{0}%'".format(s), cbSource))
        elif len(cbSourceNeg) > 0:
            abFilter['source'] = ' AND '.join(map(lambda s: "source NOT LIKE '{0}%'".format(s), cbSourceNeg))
        try:
            pg_cursor = pg.cursor()
            pg_cursor.execute("SELECT id, data, cmpldata, source, foo, move, stid, cnt FROM abuses WHERE %s ORDER BY cmpldata DESC" % \
                ' AND '.join(abFilter.values()))
            while True:
                n = 0
                for row in pg_cursor.fetchmany(CHUNK_SIZE):
                    n += 1
                    data[row[0]] = {
                        'data':     datetime.fromtimestamp(row[1]).strftime("%Y-%m-%d %H:%M:%S"),
                        'cmpldata': datetime.fromtimestamp(row[2]).strftime("%Y-%m-%d %H:%M:%S"),
                        'source':   row[3],
                        'foo':      row[4],
                        'move':     row[5],
                        'stid':     row[6],
                        'cnt':      row[7]
                    }
                if n < 1:
                    break
            pg_cursor.close()
        except Exception, e:
            writelog("DB exception: %s" % str(e), True)
try:
    env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
    template = env.get_template("users_abuse.html.template")
    print template.render(data=sorted(data.values(), cmp=lambda a, b: cmp(a['data'], b['data']), reverse=True),
                          cmplsrc=cmplSrc, foosrc=fooSrc, host=host, uid=uid, suid=suid, login=login).encode("utf-8")
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)
