#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys, re, json
from time import localtime, strftime, mktime
from datetime import datetime, timedelta
from collections import defaultdict
from log_utils import writelog
from db_utils import getMongoDB
from common import CFG, doRequest


RETRY_COUNT = 2
LIMIT = 100000
BATCH_SIZE = 1000
STATLOG = {
    'cluster': 'so_statlog',
    'hosts':   ["statlog{}.so.yandex.net".format(k) for k in ['1h', '1f', '1g', '1m', '1o', '1p', '01e', '02e', '03e', '01h', '02h', '01f', '02f']],
    'timeout': 30000,
    'db':      "solog"
}


def queryStatlog(params):
    try:
        server, args = params
        writelog("Query to statlog server: %s, args: %s" % (server, str(args)), False)
        r = doRequest("http://%s:5005/searchrangenew?%s" % (server, args), "Get deliverylog from %s" % server)
        return r if r else ""
    except Exception, e:
        writelog("Query to Statlogs failed: %s" % str(e), True)
    return ""


def querySologger(params):
    try:
        writelog("Query to Sologger, uri: %s%s&getbyid=1" % (CFG["sologger"]["uri"], params), False)
        r = doRequest("http://%s%s%s&getbyid=1" % (CFG["sologger"]["host"], CFG["sologger"]["uri"], params), "Get deliverylog from Sologger")
        return r if r else ""
    except Exception, e:
        writelog("Query to Sologger failed: %s" % str(e), True)
    return ""


def querySologgerIndex(params):
    try:
        writelog("Query to Sologger, uri: %s%s" % (CFG["sologger"]["index_uri"], params), False)
        r = doRequest("http://%s%s%s" % (CFG["sologger"]["host"], CFG["sologger"]["index_uri"], params), "Get deliverylogs stats from Sologger's index")
        return r if r else ""
    except Exception, e:
        writelog("Query to Sologger's index failed: %s" % str(e), True)
    return ""


def getDlvLog(data, is_sologger=False):
    try:
        js = json.loads(data)
    except Exception, e:
        writelog("getDlvLog failed: '%s'" % str(e), True)
        js = {}
    if is_sologger and len(js) > 10:
        key, value = "", js
        if js[1][0] == 'locl':
            m = re.search(r'-(in|out|corp)-', js[1][1])
            if m:
                key = m.group(1)
        else:
            writelog("getDlvLog unable to find route for locl: %s" % js[1], True)
        if js[0][0] == 'mess':
            m = re.match(r'\S+\s\d+\s\S+\s\S+\s(\d+)', js[0][1])
            if m:
                key += '_' + m.group(1)
        else:
            writelog("getDlvLog unable to find message's timestamp for mess: %s" % js[0], True)
        return key, value
    elif not is_sologger:
        for key, value in js.items():
            if value:
                return key, value
    else:
        writelog("getDlvLog failed to parse Sologger answer's row: '%s'" % data, True)
    return "", ""


def nextRow(payload):
    i = j = 0
    for c in payload:
        j += 1
        if c == "\n":
            yield payload[i:j]
            i = j
    if i < j:
        yield payload[i:j]


def getUserStatsFromStatlog(query, limit=LIMIT, retryCnt=RETRY_COUNT):
    stat = defaultdict(lambda: defaultdict(int))
    errStr = ""
    for attempt in range(RETRY_COUNT):
        try:
            cond, machine, date, route = query
            db = getMongoDB(STATLOG)
            for obj in db[date.strftime("so_{}%Y%m%d".format(route))].find(cond, limit=LIMIT):
                if "code" in obj:
                    stat[date.strftime("%Y-%m-%d")][obj["code"]] += 1
            break
        except Exception, e:
            errStr = "getUserStatsFromStatlog failed to receive data from DB on '%s': %s" % (machine, str(e))
            writelog(errStr, True)
    if len(stat) < 1 and errStr:
        print >>sys.stderr, errStr
        sys.exit(1)
    return dict(stat)


def getUserStatsFromSologger(uid, stat, route="in"):
    skip = 0
    while True:
        answer = querySologger("{}uid={}&route={}&skip={}&limit={}".format("" if route == "out" else "rcpt_", uid, route, skip, BATCH_SIZE))
        if answer:
            skip += BATCH_SIZE
            n = 0
            for row in nextRow(answer):
                n += 1
                try:
                    info, log = getDlvLog(row, True)
                    date, code = "", ""
                    msgInfo = info.split('_')
                    if len(msgInfo) > 1:
                        try:
                            date = strftime("%Y-%m-%d", localtime(int(msgInfo[1])))
                        except Exception, e:
                            writelog("getUserStatsFromSologger failed to parse date: %s" % str(e), True)
                            pass
                    for header in log:
                        if header[0] == "r_nl":
                            m = re.search(r' R(\d+),\s*$', header[1])
                            if m:
                                code = m.group(1)
                                break
                    stat[date][code] += 1
                except Exception, e:
                    writelog("getUserStatsFromSologger failed: msgInfo=%s, error='%s'" % (msgInfo, str(e)), True)
            if n < BATCH_SIZE:
                break
        else:
            break


def getUserStatsFromSologgersIndex(uid, stat, route="in"):
    today, uid_field = datetime.today().replace(hour=3, minute=0, second=0, microsecond=0), "log_{}uid".format("" if route == "out" else "rcpt_")
    for i in xrange(-CFG["sologger"]["saving_days"][route], 1):
        skip = 0
        d = today + timedelta(days=i)
        ts = int(mktime(d.utctimetuple()))
        stat[d.strftime("%Y-%m-%d")] = {"1": 0, "2": 0, "4": 0, "8": 0, "127": 0, "256": 0}
        while True:
            query = "get=id,{0},log_queueid,log_code,log_ts&text={0}:{1}+AND+log_ts_day:{2}+AND+log_route:{3}&skip={4}&limit={5}".format(uid_field, uid, ts, route, skip, BATCH_SIZE)
            answer = querySologgerIndex(query).strip()
            if answer:
                skip += BATCH_SIZE
                data = {}
                try:
                    data = json.loads(answer)
                    if isinstance(data, list) and len(data) > 0:
                        data = data[0]
                except Exception, e:
                    writelog("getUserStatsFromSologgersIndex failed to parse sologger's index answer: '%s'. Answer: '%s'" % (str(e), answer), True)
                    break
                if len(data) > 0 and "hitsArray" in data and "hitsCount" in data and data["hitsCount"] > 0:
                    for hit in data["hitsArray"]:
                        try:
                            stat[d.strftime("%Y-%m-%d")][str(hit["log_code"])] += 1
                        except Exception, e:
                            writelog("getUserStatsFromSologgersIndex failed add data to statistics: '%s'. Data: '%s'" % (str(e), str(hit)), True)
                    if len(data["hitsArray"]) < BATCH_SIZE:
                        break
                else:
                    break
            else:
                break
