#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys

YASM_DIR = os.environ["YASM_DIR"] if "YASM_DIR" in os.environ else "/usr/local/yasmagent"
sys.path.insert(0, YASM_DIR)
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
from socket import getfqdn
from core.modules.so.common import getCType, getDC4Host, getRoute

opts = []
prj = os.environ["YASM_PRJ"] if "YASM_PRJ" in os.environ else "so"
itype = os.environ["YASM_ITYPE"] if "YASM_ITYPE" in os.environ else "spdaemon"
ctype = getCType()
dc = getDC4Host(getfqdn())
route = getRoute()
logtype = ""
port = int(os.environ["HTTP_PORT"] if "HTTP_PORT" in os.environ else "11003")

def genGetter(logtype="", itype="spdaemon", prj="so"):
    tier = " a_tier_{0}_{1}".format(logtype, route) if logtype and route and itype == "spdaemon" else ""
    return "{0}:{1}@{2} a_itype_{2} a_prj_{3} a_ctype_{4} a_geo_{5}{6}".format(getfqdn(), port, itype, prj, ctype, dc, tier)

if "NANNY_SERVICE_ID" in os.environ:
    for instance in os.environ["YASM_INSTANCES"].split():
        if instance:
            opts.append({"logtype": instance, "itype": itype, "prj": prj})
else:
    for root, dirs, files in os.walk('/etc/default/'):
        for name in files:
            if not name.startswith('so-yasmagent-'):
                continue
            file_path = os.path.join(root, name)
            with open(file_path) as f:
                settings = {}
                for row in f.readlines():
                    kv = map(str.strip, row.strip().split("="))
                    if kv[0] == "instance":
                        settings["logtype"] = kv[1].split(',')
                    else:
                        settings[kv[0]] = kv[1]
                if "logtype" in settings:
                    for instance in settings["logtype"]:
                        tmpDict = settings.copy()
                        tmpDict["logtype"] = instance
                        opts.append(tmpDict)
                else:
                    opts.append(settings)

if not opts and "NANNY_SERVICE_ID" not in os.environ:
    sys.exit(1)

if len(opts) < 1:
    opts.append("")

print '\n'.join(map(lambda params: genGetter(**params), opts))
