#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys, time
import yt.wrapper as ytw
from traceback import format_exception
from datetime import date, timedelta, datetime


WORKING_DIR = os.environ['HOME'] if 'HOME' in os.environ else os.path.dirname(os.path.abspath(__file__))
LOGFILE = "{}/remove_empty_nodes.log".format(WORKING_DIR)
TEMP_FILES_FOLDER = "//home/so_fml/nirvana/tmp"
MAX_DATE = TODAY = date.today()
MIN_DATE = date(2015, 1, 1)


def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb


def writelog(msg, isTB = False):
    if not msg: return
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        f = open(LOGFILE, 'a')
        f.write(time.strftime("[%Y-%m-%d %H:%M:%S]: ") + msg + tb)
        f.close()
    except Exception, e:
        print("Writelog error: %s" % str(e), file=sys.stderr); sys.stdout.flush()


def cleanFolder(folder_path):
    print("Cleaning folder {}                                                   ".format(folder_path), end='\r'); sys.stdout.flush()
    yt_map = ytw.get(folder_path, attributes = ['modification_time', 'type'])
    for f in yt_map.keys():
        if yt_map[f].attributes['modification_time'] <= max_date and yt_map[f].attributes['modification_time'] >= min_date:
            node = folder_path + '/' + f
            if yt_map[f].attributes['type'] == 'map_node':
                cleanFolder(node)
                if ytw.get(node).keys() < 1 or ytw.get(node + '/@count') < 1:
                    ytw.remove(node, force = True)
                    print("Delete: '%s'                                " % node); sys.stdout.flush()
            elif yt_map[f].attributes['type'] == 'table' and ytw.row_count(node) == 0:
                ytw.remove(node, force = True)
                print("Delete: '%s'                                    " % node); sys.stdout.flush()
    if ytw.get(folder_path).keys() < 1 or ytw.get(folder_path + '/@count') < 1:
        ytw.remove(folder_path, force = True)
        print("Delete: '%s'                                            " % folder_path); sys.stdout.flush()


if len(sys.argv) > 1:
    try:
        MAX_DATE = datetime.strptime(sys.argv[1], '%Y-%m-%d').date()
    except Exception, e:
        print("Exception: %s" % str(e), file=sys.stderr); sys.stdout.flush()

if len(sys.argv) > 2:
    try:
        MIN_DATE = datetime.strptime(sys.argv[2], '%Y-%m-%d').date()
    except Exception, e:
        print("Exception: %s" % str(e), file=sys.stderr); sys.stdout.flush()

print("Gathering info about folders...", end='\r'); sys.stdout.flush()
max_date, min_date = MAX_DATE.isoformat(), MIN_DATE.isoformat()
yt_map = ytw.get(TEMP_FILES_FOLDER, attributes = ['modification_time', 'type'])

for f in yt_map.keys():
    if yt_map[f].attributes['modification_time'] <= max_date and yt_map[f].attributes['modification_time'] >= min_date and yt_map[f].attributes['type'] == 'map_node':
        cleanFolder(TEMP_FILES_FOLDER + '/' + f)

