#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys, json, re, time, pymongo
import yt.wrapper as yt
from traceback import format_exception
from datetime import date, timedelta, datetime


TEMP_FILES_FOLDER = "//home/so_fml/nirvana/tmp"
TODAY = date.today()
MAX_DATE = TODAY - timedelta(days=10)
MIN_DATE = date(2017, 1, 1)
RETRY_COUNT = 3
TMP_FILES_PREFIX = ['tmp_bounceslog_m_', 'tmp_rules_complaints_log_']


def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb


def writelog(msg, isTB = False):
    if not msg: return
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        f = open(LOGFILE, 'a')
        f.write(time.strftime("[%Y-%m-%d %H:%M:%S]: ") + msg + tb)
        f.close()
    except Exception, e:
        print >>sys.stderr, "Writelog error: %s" % str(e)


def removeTable(tableName, tableFolder=TEMP_FILES_FOLDER):
    tablePath = tableFolder + '/' + tableName
    if yt.exists(tablePath):
        print "Removing table: %s" % tablePath
        try:
            yt.remove(tablePath, recursive=True, force=True)
        except Exception, e:
            pass


if len(sys.argv) > 1:
    try:
        MAX_DATE = datetime.strptime(sys.argv[1], '%Y-%m-%d').date()
    except Exception, e:
        print >>sys.stderr, "Exception: %s" % str(e)
        MAX_DATE = TODAY - timedelta(days=180)
if len(sys.argv) > 2:
    try:
        MIN_DATE = datetime.strptime(sys.argv[2], '%Y-%m-%d').date()
    except Exception, e:
        print >>sys.stderr, "Exception: %s" % str(e)
        MIN_DATE = TODAY - timedelta(days=540)
max_date, min_date = MAX_DATE.isoformat(), MIN_DATE.isoformat()
yt_map = yt.get(TEMP_FILES_FOLDER, attributes = ['modification_time', 'type'])

for f in yt_map.keys():
    if yt_map[f].attributes['modification_time'] < max_date and yt_map[f].attributes['modification_time'] > min_date and yt_map[f].attributes['type'] == 'table':
        for file_prefix in TMP_FILES_PREFIX:
            if f.startswith(file_prefix):
                removeTable(f)
