#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, sys, json, re, time
import yt.wrapper as yt
from traceback import format_exception
from datetime import date, timedelta, datetime


TEMP_FILES_FOLDER = "//home/so_fml/nirvana/tmp"
LOGFILE = "{}/remove_zero_files.log".format(WORKING_DIR)
TODAY = date.today()
MAX_DATE = TODAY - timedelta(days=180)
MIN_DATE = '2017-01-01'
RETRY_COUNT = 3


def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb


def writelog(msg, isTB = False):
    if not msg: return
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        f = open(LOGFILE, 'a')
        f.write(time.strftime("[%Y-%m-%d %H:%M:%S]: ") + msg + tb)
        f.close()
    except Exception, e:
        print("Writelog error: %s                                                     " % str(e), file=sys.stderr); sys.stdout.flush()


def removeZeroTable(tableName, tableFolder=TEMP_FILES_FOLDER):
    tablePath = tableFolder + '/' + tableName
    if yt.exists(tablePath) and yt.row_count(tablePath) < 1:
        print("Removing table: %s                                                     " % tablePath); sys.stdout.flush()
        try:
            yt.remove(tablePath, recursive=True, force=True)
        except Exception, e:
            pass


def cleanupFolder(folderName, folder):
    folderPath = folder + '/' + folderName
    print("Cleaning folder {}                                                         ".format(folderPath), end='\r'); sys.stdout.flush()
    yt_subfolder = yt.get(folderPath, attributes=['modification_time', 'type'])
    if len(yt_subfolder) > 0:
        for node in yt_subfolder.keys():
            if yt_subfolder[node].attributes['type'] == 'map_node':
                cleanupFolder(node, folderPath)
            else:
                removeZeroTable(node, folderPath)
    else:
        print("Removing folder: %s                                                    " % folderPath); sys.stdout.flush()
        try:
            yt.remove(folderPath, recursive=True, force=True)
        except Exception, e:
            pass


print("Gathering info about folders...", end='\r'); sys.stdout.flush()
max_date, min_date = MAX_DATE.isoformat(), MIN_DATE
yt_map = yt.get(TEMP_FILES_FOLDER, attributes=['modification_time', 'type'])

for f in yt_map.keys():
    if yt_map[f].attributes['type'] == 'map_node':
        cleanupFolder(f, TEMP_FILES_FOLDER)
    else:
        removeZeroTable(f)
