#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, argparse, requests, json
import yt.wrapper as ytw
from datetime import date, timedelta, datetime
from traceback import format_exception
from collections import defaultdict
from time import time

WORKING_DIR = os.environ['HOME'] if 'HOME' in os.environ else os.path.dirname(os.path.abspath(__file__))
ROBOT = {'login': 'robot_klimiky', 'passwd': ''}

def loadCredentials(cfg):
    f, CURDIR = None, WORKING_DIR
    try:
        if not os.path.exists('{0}/.stat.robot'.format(CURDIR)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
        f = open('{0}/.stat.robot'.format(CURDIR))
        for line in f:
            sf = line.split(':')
            if len(sf) == 2:
                cfg['user'], cfg['password'] = sf[0], sf[1].strip()
                break
        f.close()
    except Exception, e:
        writelog("loadCredentials exception: %s" % str(e), True)

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def send_yastat(data):
    start = time()
    for i in range(3):
        r = requests.post('https://upload.stat.yandex-team.ru/_api/report/data',
            headers = {'StatRobotUser': ROBOT['login'], 'StatRobotPassword': ROBOT['passwd']},
            data = {
                'name': 'So/Out_KPI_1',
                'scale': 'd',
                'data': json.dumps({'values': data}),
            })
        if r.status_code == 200:
            break
    return time() - start, r.status_code

if __name__ == "__main__":
    YT_KPI_DATA_TABLE = '//home/so_fml/KPI/so_out_KPI_1_2016-12-16'
    parser = argparse.ArgumentParser()
    parser.add_argument('-d', '--data_table', type = str, help = "Path to YT table with data to upload to YaStat")
    parser.add_argument('-u', '--stat_url',   type = str, help = "URL to YaStat report")
    args = parser.parse_known_args()[0]
    if args.data_table:
        YT_KPI_DATA_TABLE = args.data_table
    data = []
    for r in ytw.read_table(YT_KPI_DATA_TABLE, format = ytw.JsonFormat(), raw = False):
        data.append(r)
    loadCredentials(ROBOT)
    if len(data) > 0:
        dt, st = send_yastat(data)
        if st != 200:
            print "Error during sending data to YaStat"
        print "Sending basic KPI data to YaStat done in %d sec with status %d" % (dt, st); sys.stdout.flush()
    else:
        print "KPI data is absent"
