#pragma once

#include <string>
#include <nwsmtp/remote_point.h>

#include <yplatform/ptree.h>

struct avir_client_options
{
    int connect_timeout = 1;
    int timeout = 1;
    remote_point primary;
    remote_point secondary;
    int retries = 1;

    enum protocol_t
    {
        drweb, icap
    } protocol = icap;

    std::string icap_service;
};

struct avir_options
{
    using ptree = yplatform::ptree;

    bool check = false;
    avir_client_options client_opts;

    std::string reply_text = "Message infected by virus";
    std::string reply_text_discard = "Message infected by virus";

    enum virus_policy
    {
        DISCARD,
        REJECT
    };

    static virus_policy policy_from_string(const std::string& s);

    virus_policy action_virus = DISCARD;

    avir_options() = default;

    avir_options(const ptree& tree);

    void read(const ptree& tree);
};
