#pragma once

#include <iostream>

class CMimeDecoder
{
	public:

		typedef enum { ERROR_ENCODING, ERROR_STREAM } mime_error_t;

		typedef void (*proto_decode) (std::istream &in, std::ostream &out);
		typedef void (*proto_encode) (std::istream &in, std::ostream &out, const char *_file_name);

		typedef struct { const char *full_name; const char short_name; proto_encode encode_proc; proto_decode decode_proc; } proto_entry_t;
		
		CMimeDecoder();
		virtual ~CMimeDecoder();

		void decode_short(char _short, std::istream &in, std::ostream &out);
		void encode_short(char _short, std::istream &in, std::ostream &out);

		void encode(const char *_name, std::istream &in, std::ostream &out, const char *_file_name = 0);
		void decode(const char *_name, std::istream &in, std::ostream &out);

		static const proto_entry_t proto_entry_list[];
		
	protected:
		bool find_short(char ch, CMimeDecoder::proto_encode &_encode, CMimeDecoder::proto_decode &_decode);
		bool find(const char *name, CMimeDecoder::proto_encode &_encode, CMimeDecoder::proto_decode &_decode);
};

