#pragma once

namespace NNwSmtp {

enum HostOrder {PRIMARY_PREFERRED, ALTERNATING};

template <HostOrder order>
struct HostChooser;

template <>
struct HostChooser<PRIMARY_PREFERRED> {
    template <typename Host>
    static const Host& choose(
        const Host& primary,
        const Host& secondary,
        unsigned attemptsPerHost,
        unsigned usedAttempts)
    {
        if (usedAttempts >= 2 * attemptsPerHost) {
            throw std::logic_error("too many attempts");
        }
        return usedAttempts < attemptsPerHost ? primary : secondary;
    }
};

template <>
struct HostChooser<ALTERNATING> {
    template <typename Host>
    static const Host& choose(
        const Host& primary,
        const Host& secondary,
        unsigned attemptsPerHost,
        unsigned usedAttempts)
    {
        if (usedAttempts >= 2 * attemptsPerHost) {
            throw std::logic_error("too many attempts");
        }
        return (usedAttempts % 2 == 0) ? primary : secondary;
    }
};

}   // namespace NNwSmtp
