#pragma once

#include "resolver.h"

#include <yplatform/log.h>

#include <functional>
#include <string>
#include <vector>

class THostsResolver {
public:
    using TResolver = NNwSmtp::resolver_t;
    using TStrand = boost::asio::io_service::strand;
    using TCallback = std::function<void(std::string ipAddress)>;
    using TResult = std::vector<boost::asio::ip::address>;

    explicit THostsResolver(const resolver_options& resolverOptions);

    template <typename TContainer>
    TResult ResolveHosts(const TContainer& hosts) {
        for (const auto& host : hosts) {
            Strand.dispatch([this, &rawAddress = host](){
                boost::system::error_code ec;
                auto address = boost::asio::ip::make_address(rawAddress, ec);

                if (!ec) {
                    Result.push_back(std::move(address));
                } else {
                    AsyncResolve(rawAddress, Resolver, Strand, [&result = Result](std::string address) {
                        if (!address.empty()) {
                            result.push_back(boost::asio::ip::make_address(address));
                        }
                    });
                }
            });
        }

        IoService.run();

        TResult result;
        std::swap(result, Result);

        return result;
    }

    static void AsyncResolve(
        std::string hostname,
        TResolver& resolver,
        TStrand strand,
        TCallback callback);

private:
    boost::asio::io_service IoService;
    TStrand Strand;
    TResolver Resolver;
    TResult Result;
};
