#include <nwsmtp/avir_options.h>


avir_options::virus_policy avir_options::policy_from_string(const std::string& s)
{
    if (s == "discard")
        return DISCARD;
    else if (s == "reject")
        return REJECT;
    else
        throw std::runtime_error("no such virus action: " + s);
}

avir_options::avir_options(const ptree& tree)
{
    read(tree);
}

void avir_options::read(const ptree& tree)
{
    check = tree.get<bool>("check", false);

    if (auto o = tree.get_optional<std::string>("reply_text"))
        reply_text = o.value();
    if (auto o = tree.get_optional<std::string>("reply_text_discard"))
        reply_text_discard = o.value();

    auto cs = tree.get_child("client_settings");
    client_opts.connect_timeout = cs.get<int>("connect_timeout", 1);
    client_opts.timeout = cs.get<int>("data_timeout", 10);

    auto p = cs.get<std::string>("primary");
    client_opts.primary = remote_point::from_string(p);

    auto s = cs.get<std::string>("secondary");
    client_opts.secondary = remote_point::from_string(s);

    client_opts.retries = cs.get<int>("try", 2);

    if (auto is = cs.get_optional<std::string>("icap_service"))
        client_opts.icap_service = is.value();

    auto proto = cs.get<std::string>("protocol", "icap");
    if (proto == "icap")
        client_opts.protocol = avir_client_options::icap;
    else if (proto == "drweb")
        client_opts.protocol = avir_client_options::drweb;
    else
        throw std::runtime_error("no such protocol: " + proto);

    auto action = tree.get<std::string>("action.virus", "discard");
    action_virus = policy_from_string(action);
}

