#include <stdio.h>
#include <string.h>

#include <nwsmtp/decoder/mimedecoder.h>

#define DECLARE_ENCODING_TYPE(A)	static void A (std::istream &in, std::ostream &out, const char *_file_name)
#define DECLARE_DECODING_TYPE(A)	static void A (std::istream &in, std::ostream &out)

CMimeDecoder::CMimeDecoder()
{
}

CMimeDecoder::~CMimeDecoder()
{
}

bool CMimeDecoder::find_short(char ch, CMimeDecoder::proto_encode &_encode, CMimeDecoder::proto_decode &_decode)
{
	proto_entry_t *cur_proto;

	for( cur_proto = (proto_entry_t *)proto_entry_list; cur_proto->full_name != 0; cur_proto++)
	{
		if (cur_proto->short_name == ch)
		{
			_encode = cur_proto->encode_proc;
			_decode = cur_proto->decode_proc;
			return true;
		}
	}
	_encode = 0;
	_decode = 0;
	return false;
}

bool CMimeDecoder::find(const char *name,  CMimeDecoder::proto_encode &_encode, CMimeDecoder::proto_decode &_decode)
{
	proto_entry_t *cur_proto;

	for( cur_proto = (proto_entry_t *)proto_entry_list; cur_proto->full_name != 0; cur_proto++)
	{
		if (strncasecmp(cur_proto->full_name, name, strlen(cur_proto->full_name)) == 0)
		{
			_encode = cur_proto->encode_proc;
			_decode = cur_proto->decode_proc;
			return true;
		}
	}
	_encode = 0;
	_decode = 0;
	return false;
}

void CMimeDecoder::decode_short(char _short, std::istream &in, std::ostream &out)
{
	CMimeDecoder::proto_encode encode;
	CMimeDecoder::proto_decode decode;

	if (find_short(_short, encode, decode))		// exception may be here
		decode(in, out);
	else
		throw CMimeDecoder::ERROR_ENCODING;
}

void CMimeDecoder::encode_short(char _short, std::istream &in, std::ostream &out)
{
	CMimeDecoder::proto_encode encode;
	CMimeDecoder::proto_decode decode;

	if (find_short(_short, encode, decode))		// exception may be here
		encode(in, out, 0);
	else
		throw CMimeDecoder::ERROR_ENCODING;

}

void CMimeDecoder::encode(const char *_name, std::istream &in, std::ostream &out, const char *_file_name)
{
	CMimeDecoder::proto_encode encode_proc;
	CMimeDecoder::proto_decode decode_proc;

	if (find(_name, encode_proc, decode_proc))		// exception may be here
		encode_proc(in, out, _file_name);
	else
		throw CMimeDecoder::ERROR_ENCODING;
}

void CMimeDecoder::decode(const char *_name, std::istream &in, std::ostream &out)
{
	CMimeDecoder::proto_encode encode_proc;
	CMimeDecoder::proto_decode decode_proc;

	if (find(_name, encode_proc, decode_proc)) {		// exception may be here
		decode_proc(in, out);
	} else
		throw CMimeDecoder::ERROR_ENCODING;
}

#define LEFT_BOUND	71

// Do not change the sizes before adjusting the code! A lot of range-checks are absent due to optimization!
#define OUTPUT_BUF_SIZE 76
#define INPUT_BUF_SIZE 57

static const char BASE64_ENCODEARRAY[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static const char BASE64_DECODEARRAY[] =
{
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,

	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 0x3e, -1, -1, -1, 0x3f,
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
	0x3c, 0x3d, -1, -1, -1, -1, -1, -1,

	-1, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, -1, -1, -1, -1, -1,

	-1, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
	0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
	0x31, 0x32, 0x33, -1, -1, -1, -1, -1,

	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1
};

static inline int iread(std::istream *in, char *buf, int size) {
#if 0
	int i;
	char ch;
	for(i=0; i<size; ++i) {
		ch = in->get();
		if(ch == std::istream::traits_type::eof()) {
			return i;
		}
		std::cerr << ch;
		buf[i] = ch;
	}
	return i;
#else
	in->read(buf,size);
	return in->gcount();
#endif
}

DECLARE_ENCODING_TYPE(encode_base64)
{
	(void)_file_name; // Prevent 'unused parameter' warning.

	char inbuf[ INPUT_BUF_SIZE ];
	int readlen;
	
	// Read the file block-by-block
	
	while ( ( readlen = iread (&in, inbuf, sizeof( inbuf ) ) ) > 0 )
	{
		char outbuf[ OUTPUT_BUF_SIZE + 1 ];
		unsigned int outptr = 0;
		unsigned long triple = 0x00000080; // by shifting << 8 three times, it will become 0x80xxxxxx.
		int inptr = 0;
		
		for ( inptr = 0; inptr < readlen; inptr++ )
		{
			triple = ( triple << 8 ) | ( unsigned char ) inbuf[ inptr ]; // format triple
			
			if ( triple & 0x80000000 )  // got 3rd character
			{
				outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 18 ) & 0x3F ];
				outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 12 ) & 0x3F ];
				outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 6 ) & 0x3F ];
				outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ triple & 0x3F ];
				
				triple = 0x000000FF;
			}
		}
		
		// If the result is not aligned on 3, some bytes left unencoded. Add them here.
		if ( ( inptr % 3 ) != 0 )
		{
			unsigned int left_unencoded = ( inptr % 3 ) + 1;
			unsigned int left_padding = 4 - left_unencoded;
			
			switch ( left_unencoded )  // 0 and 3 are impossible.
			{
			
					case 3:
					outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 10 ) & 0x3F ];
					outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 4 ) & 0x3F ];
					outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple << 2 ) & 0x3F ];
					break;
					
					case 2:
					outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple >> 2 ) & 0x3F ];
					// no break, we have more data to encode.
					
					case 1:
					outbuf[ outptr++ ] = BASE64_ENCODEARRAY [ ( triple << 4 ) & 0x3F ];
			}
			
			switch ( left_padding )
			{
			
					case 3:
					outbuf[ outptr++ ] = '='; // no break, continue padding
					
					case 2:
					outbuf[ outptr++ ] = '='; // no break, continue padding
					
					case 1:
					outbuf[ outptr++ ] = '='; // no break, continue padding
			}
		}
		
                //		outbuf[ outptr++ ] = '\n';
		out.write(outbuf, outptr);
	}
}

DECLARE_DECODING_TYPE(decode_base64)
{
	// Do not change the sizes before adjusting the code! A lot of range-checks are absent due to optimization!
	unsigned char inbuf [ 8 * OUTPUT_BUF_SIZE ];
	unsigned int triplecount = 0; // needed because not every char can be decoded
	unsigned long triple = 0;
	int readlen;
	
	// Read the file block-by-block
	
	while ( ( readlen = iread (&in, (char *)inbuf, sizeof( inbuf ) ) ) > 0 )
	{
		char outbuf[ 8 * INPUT_BUF_SIZE + 8 ]; // reserve
		unsigned int outptr = 0;
		
		for ( int inptr = 0; inptr < readlen; inptr++ )
		{
			char data = BASE64_DECODEARRAY[ inbuf[ inptr ] ]; // decode a character
			
			if ( data == -1 )
				continue;
				
			triple = ( triple << 6 ) | ( data & 0x3F );
			
			triplecount++;
			
			if ( triplecount == 4 )  // got the 3rd decoded byte
			{
				// We should not get out of outbuf boundary here, because inbuf contains no
				// more data than decoded base64.
				outbuf[ outptr++ ] = ( unsigned char ) ( triple >> 16 );
				outbuf[ outptr++ ] = ( unsigned char ) ( triple >> 8 );
				outbuf[ outptr++ ] = ( unsigned char ) triple;
				triple = triplecount = 0;
			}
		}
		
		// Handle unfinished triples at the end of file
		if ( readlen != sizeof( inbuf ) )
		{
			switch ( triplecount )
			{
			
					case 3:
					outbuf[ outptr++ ] = ( unsigned char ) ( triple >> 10 );
					outbuf[ outptr++ ] = ( unsigned char ) ( triple >> 2 );
					break;
					
					case 2:
					outbuf[ outptr++ ] = ( unsigned char ) ( triple >> 4 );
					break;
			}
		}
		
		// outptr may be 0 - for example, if there is 2k of spaces at the beginning of the message
		if ( outptr )
			out.write ( outbuf, outptr );
	}
}

#define QP	1
#define SP	2
#define NL	3

char toqp[256] = {
/*      0   1   2   3   4   5   6   7    8   9   A   B   C   D   E   F */
/* 0 */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, SP, NL, QP, QP, QP, QP, QP,
/* 1 */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* 2 */	SP,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
/* 3 */	 0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0, QP,  0,  0,

/* 4 */	 0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
/* 5 */	 0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
/* 6 */	 0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
/* 7 */	 0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0, QP,

/* 8 */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* 9 */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* A */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* B */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,

/* C */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* D */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* E */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP,
/* F */	QP, QP, QP, QP, QP, QP, QP, QP,  QP, QP, QP, QP, QP, QP, QP, QP
};


DECLARE_ENCODING_TYPE(encode_qp)
{
    (void)_file_name; // Prevent 'unused parameter' warning.

    int linelen = 0;
    char lastspace = 0;
    char cbuf[5];
    int ch;

	if ((!in.good()) || (!out.good())) return;

    while (1)
    {
		ch = in.get();

		if (in.eof()) break;

		if ((linelen > LEFT_BOUND) && (ch != '\n'))		// check left bound
		{
	    	if (lastspace)
	    	{
				out.put(lastspace);		// Rule #2
				lastspace = 0;
	    	}

			out.put('=');
			out.put('\r');
			out.put('\n');		// put soft line break

	    	linelen = 0;
		}


		if (toqp[ch] == NL)
		{
			if (lastspace != 0)
			{
				sprintf(cbuf, "=%.2X\n", (unsigned char)lastspace);
				out.put(cbuf[0]); out.put(cbuf[1]); out.put(cbuf[2]);
				lastspace = 0;
			}

			out.put('\r'); out.put('\n');
			linelen = 0;
		}
		else
		{
			if (lastspace)
			{
				out.put(lastspace);		// Rule #2
				lastspace = 0;
				linelen++;
			}

			switch (toqp[ch])
			{
				case QP:		// put quote printable character Rule #1
					sprintf(cbuf, "=%.2X", ch);
					out.put(cbuf[0]); out.put(cbuf[1]); out.put(cbuf[2]);
					linelen += 3;
				break;

				case SP:		// process \t and space
					lastspace = (char)ch;
				break;

				default:    	// put not quote printable character Rule#2
					out.put(ch);
					linelen++;
				break;
			}

		}
    }
	
	// Put soft line break
	
	out.put('\r'); out.put('\n');

}

DECLARE_DECODING_TYPE(decode_qp)
{
    char t[3];
    unsigned int ch = 0;

	if ((!in.good()) || (!out.good())) return;

    do {

		ch = in.get();

		if (in.eof()) break;

		switch (ch)
		{

	    	case '=':		// process quoted

				ch = in.get();
				if (in.eof()) break;

				if (ch == '\r')
				{
					ch = in.get();
					if (in.eof()) break;
				}

				if (ch != '\n')		// soft line break - skip
				{
	    	    	t[0] = ch;

					t[1] = in.get();
					if (in.eof()) break;	// Not normal - skip no output
		    		t[2] = 0;

	    	    	if (sscanf(t,"%2x",&ch) != 1) break; // Not normal - invalid format,skip no output
				}
				else
				  break;	// skip soft line break

				default: // process not quoted
					out.put(ch);

	  			break;
		}

    } while (!in.eof());
}

#define UUE_STR_BUF_SIZE	100
#define UU_BEGIN	"begin"
#define UU_END	"end"
#define	UU_DEC(c)	(((c) - ' ') & 077)		/* single character decode */
#define UU_IN_RANGE(c) ((c >='!') && (c <= '`'))


DECLARE_DECODING_TYPE(decode_uue)
{
 	if ((!in.good()) || (!out.good())) return;

 	char buffer[UUE_STR_BUF_SIZE+1];

	bool skip_begin = true;

 	while (in.getline(buffer, UUE_STR_BUF_SIZE))
 	{
		char *p = buffer;
		const int buf_len = strlen(buffer);

		if ((buf_len == 0) || in.eof()) // found empty line or eof
			break;

		if (skip_begin && (strncasecmp(buffer, UU_BEGIN, strlen(UU_BEGIN)) == 0)) //case found begin XXX name
			continue;

		if (!UU_IN_RANGE(*p) || (*p == '\n')) // found invalid character
			continue;

		int n;
		skip_begin = false;

		if ((n = UU_DEC(*p)) <= 0)
			break;

		if ((n/3*4) > buf_len)				// Found invalid line length remember or '\r\n' or '\n'
			continue;

		for (++p; n > 0; p += 4, n -= 3)
		{
			char ch;

			if (n >= 3)
			{
				ch = UU_DEC(p[0]) << 2 | UU_DEC(p[1]) >> 4;
				out.put(ch);
				ch = UU_DEC(p[1]) << 4 | UU_DEC(p[2]) >> 2;
				out.put(ch);
				ch = UU_DEC(p[2]) << 6 | UU_DEC(p[3]);
				out.put(ch);
			}
			else
			{
				if (n >= 1) {
					ch = UU_DEC(p[0]) << 2 | UU_DEC(p[1]) >> 4;
					out.put(ch);
				}
				if (n >= 2) {
					ch = UU_DEC(p[1]) << 4 | UU_DEC(p[2]) >> 2;
					out.put(ch);
				}
				if (n >= 3) {
					ch = UU_DEC(p[2]) << 6 | UU_DEC(p[3]);
					out.put(ch);
				}
			}
		}
 	}
}

#define	ENC(c) ((c) ? ((c) & 077) + ' ': '`')

DECLARE_ENCODING_TYPE(encode_uue)
{
	int ch, n;
	char *p;
	char buf[80];

	if ((!in.good()) || (!out.good())) return;

	if (_file_name)
	{
		out << "\nbegin 666 " << _file_name << '\n';
	}

	while (in.good())
	{
		in.read(buf, 45);
		n = in.gcount();

		ch = ENC(n);
		out.put(ch);

		for (p = buf; n > 0; n -= 3, p += 3)
		{
			ch = *p >> 2;
			ch = ENC(ch);
			out.put(ch);

			ch = ((*p << 4) & 060) | ((p[1] >> 4) & 017);
			ch = ENC(ch);
			out.put(ch);

			ch = ((p[1] << 2) & 074) | ((p[2] >> 6) & 03);
			ch = ENC(ch);
			out.put(ch);

			ch = p[2] & 077;
			ch = ENC(ch);
			out.put(ch);
		}

		out.put('\n');
	}

 	if (!out.good()) return;

	ch = ENC('\0');
	out.put(ch);
	out.put('\n');

	if (_file_name)
	{
		out << "end\n";
	}

}

const CMimeDecoder::proto_entry_t CMimeDecoder::proto_entry_list[] = {
	{"base64", 'b', encode_base64, decode_base64 },
	{"quoted-printable", 'q', encode_qp, decode_qp },
	{"x-uue", 'u', encode_uue, decode_uue },
	{0, 0, 0, 0}
};
