#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/ymod_queuedb/include/logdog.h>
#include <mail/webmail/corgi/include/logdog.h>
#include <mail/spaniel/core/include/types.h>


namespace spaniel {
namespace log {
using namespace ::corgi::attr;
using namespace ::logdog::attr;
using namespace ::ymod_queuedb::attr;
}

inline auto getTskvArgsLogger(const std::string& name) {
    return yplatform::log::find(name, true);
}

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-spaniel-tskv-log"));

inline auto getModuleLogger(const std::string& name) {
    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(yplatform::log::find(name, true))
    );
}

inline auto getModuleLogger() {
    return getModuleLogger("spaniel");
}

using ModuleLogger = decltype(getModuleLogger());

template<class UidParam, class OrgIdParam, class ReqIdParam>
auto getContextLoggerImpl(UidParam&& uidParam,
                          OrgIdParam&& orgParam,
                          ReqIdParam&& reqParam) {
    return ::logdog::bind(
        getModuleLogger(),
        std::forward<UidParam>(uidParam),
        std::forward<OrgIdParam>(orgParam),
        std::forward<ReqIdParam>(reqParam)
    );
}

inline auto getContextLogger(const std::optional<std::string>& adminUid,
                             const std::optional<std::string>& orgId,
                             const std::optional<std::string>& requestId) {

    return getContextLoggerImpl(
        log::admin_uid=adminUid,
        log::org_id=orgId,
        log::x_request_id=requestId.value_or("")
    );
}

inline auto getContextLogger(const CommonParams& c) {
    return getContextLoggerImpl(
        log::admin_uid=std::to_string(c.adminUid),
        log::org_id=std::to_string(c.orgId),
        log::x_request_id=c.requestId
    );
}

inline auto getContextLogger(const OrganizationParams& c) {
    return getContextLoggerImpl(
        log::admin_uid=std::nullopt,
        log::org_id=std::to_string(c.orgId),
        log::x_request_id=c.requestId
    );
}

using ContextLogger = decltype(getContextLogger(CommonParams()));

}
