#pragma once

#include <mail/spaniel/core/include/types.h>
#include <mail/webmail/corgi/include/types_error.h>


namespace spaniel {

enum class ServiceError {
    noSearchWithSearchId = ENUM_ERROR_STARTING_VALUE,
};

enum class RemoteServiceError {
    search = ENUM_ERROR_STARTING_VALUE,
    proxy
};

struct ServiceCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "service";
    }

    std::string message(int v) const override;
};
const ServiceCategory& getServiceCategory();
mail_errors::error_code::base_type make_error_code(ServiceError e);
mail_errors::error_code make_error(ServiceError e, std::string what="");
inline auto make_unexpected(ServiceError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}


struct RemoteServiceCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "remote";
    }

    std::string message(int v) const override;
};
const RemoteServiceCategory& getRemoteServiceCategory();
mail_errors::error_code::base_type make_error_code(RemoteServiceError e);
mail_errors::error_code make_error(RemoteServiceError e, std::string what="");
inline auto make_unexpected(RemoteServiceError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}


namespace boost::system {
template <>
struct is_error_code_enum<spaniel::ServiceError> : std::true_type { };
template <>
struct is_error_code_enum<spaniel::RemoteServiceError> : std::true_type { };
}
