#pragma once

#include <mail/spaniel/core/include/types.h>
#include <boost/fusion/include/adapt_struct.hpp>
#include <yamail/data/reflection.h>
#include <mail/webmail/corgi/include/types_reflection.h>


YREFLECTION_ADAPT_ENUM(spaniel::SearchState,
    in_progress,
    partially_complete,
    archived,
    error,
    complete
)

YREFLECTION_ADAPT_ADT(spaniel::Query,
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, has_attachments, hasAttachments)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, text)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, subject)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, from)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, to)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, cc)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, bcc)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::vector<std::string>>, to_cc_bcc, toCcBcc)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, scope)
    YREFLECTION_MEMBER(std::optional<std::string>, request)

    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Departments>, include_departments, resolveUsers.includeDepartments)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Departments>, exclude_departments, resolveUsers.excludeDepartments)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Uids>, include_uids, resolveUsers.includeUids)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Uids>, exclude_uids, resolveUsers.excludeUids)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Groups>, include_groups, resolveUsers.includeGroups)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Groups>, exclude_groups, resolveUsers.excludeGroups)
)

YREFLECTION_ADAPT_ADT(spaniel::Search,
    YREFLECTION_MEMBER_RENAMED(spaniel::OrgId, org_id, orgId)
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER_RENAMED(spaniel::Uid, admin_uid, adminUid)
    YREFLECTION_MEMBER_RENAMED(spaniel::Uids, requested_uids, requestedUids)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Uids>, found_uids, foundUids)
    YREFLECTION_MEMBER(spaniel::Query, query)
    YREFLECTION_MEMBER(std::string, name)
    YREFLECTION_MEMBER(spaniel::SearchState, state)
    YREFLECTION_MEMBER_RENAMED(std::time_t, date_from, dateFrom)
    YREFLECTION_MEMBER_RENAMED(std::time_t, date_to, dateTo)
    YREFLECTION_MEMBER(std::time_t, created)
    YREFLECTION_MEMBER(std::time_t, updated)
)

YREFLECTION_ADAPT_ADT(spaniel::SendShareParams,
    YREFLECTION_MEMBER(std::string, to)
)

YREFLECTION_ADAPT_ENUM(spaniel::ActionHistoryType,
    create_search,
    send_share
)

YREFLECTION_ADAPT_ADT(spaniel::ActionHistoryInfo::SendShare,
    YREFLECTION_MEMBER(std::string, to)
    YREFLECTION_MEMBER(spaniel::Uid, uid)
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(std::string, mid)
)

YREFLECTION_ADAPT_ADT(spaniel::SingleMessageAccessParams,
    YREFLECTION_MEMBER(spaniel::Uid, uid)
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(std::string, mid)
)

YREFLECTION_ADAPT_ADT(spaniel::MessagesAccessParams,
    YREFLECTION_MEMBER(spaniel::Uid, uid)
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(std::vector<std::string>, mids)
)

YREFLECTION_ADAPT_ADT(spaniel::ActionHistoryInfo::CreateSearch,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
)

YREFLECTION_ADAPT_ADT(spaniel::ActionHistoryInfo,
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::ActionHistoryInfo::SendShare>, send_share, sendShare)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::ActionHistoryInfo::CreateSearch>, create_search, createSearch)
)

YREFLECTION_ADAPT_ADT(spaniel::ActionHistoryItem,
    YREFLECTION_MEMBER_RENAMED(spaniel::Id, action_id, actionId)
    YREFLECTION_MEMBER_RENAMED(spaniel::Uid, admin_uid, adminUid)
    YREFLECTION_MEMBER(spaniel::ActionHistoryType, type)
    YREFLECTION_MEMBER(spaniel::ActionHistoryInfo, info)
    YREFLECTION_MEMBER(std::time_t, date)
)
