#include <mail/spaniel/core/include/types.h>
#include <mail/spaniel/core/include/types_error.h>
#include <mail/webmail/http_api_helpers/include/error.h>


namespace spaniel {

yamail::expected<void> MessagesBySearchParams::validate(const boost::optional<Search>& search) const {
    using yamail::make_unexpected;

    if (!search) {
        return make_unexpected(make_error(ServiceError::noSearchWithSearchId, std::to_string(searchId)));
    }

    return yamail::make_expected();
}

yamail::expected<void> MessagesBySearchAndUidParams::validate(const boost::optional<Search>& search) const {
    using yamail::make_unexpected;

    if (auto expected = MessagesBySearchParams::validate(search); !expected) {
        return expected;
    }
    if (search->requestedUids.end() == std::find(search->requestedUids.begin(), search->requestedUids.end(), uid)) {
        return make_unexpected(make_error(corgi::AccessError::accessDenied, "no uid in search"));
    }

    return yamail::make_expected();
}

}
