#include <mail/spaniel/core/include/types_error.h>
#include <mail/spaniel/core/include/types.h>


namespace spaniel {


std::string ServiceCategory::message(int v) const {
    switch(ServiceError(v)) {
        case ServiceError::noSearchWithSearchId:
            return "no such search id";
    }
    return "unknown enum code";
}

const ServiceCategory& getServiceCategory() {
    static ServiceCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ServiceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getServiceCategory());
}

mail_errors::error_code make_error(ServiceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}


std::string RemoteServiceCategory::message(int v) const {
    switch (RemoteServiceError(v)) {
        case RemoteServiceError::search:
            return "search";
        case RemoteServiceError::proxy:
            return "proxy";
    }
    return "unknown enum code";
}

const RemoteServiceCategory& getRemoteServiceCategory() {
    static RemoteServiceCategory category;
    return category;
}

mail_errors::error_code::base_type make_error_code(RemoteServiceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getRemoteServiceCategory());
}

mail_errors::error_code make_error(RemoteServiceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
