#pragma once

#include <mail/webmail/http_api_helpers/include/response.h>
#include <mail/spaniel/core/include/log.h>
#include <mail/spaniel/service/include/result.h>


namespace spaniel {

class Response: public http_api::Response {
protected:
    void defaultProxyResponse(JsonProxyResult&& resp) const;
    void logSuccessResponse(const std::string& body) const override;
    void logErrorResponse(const std::string& body) const override;
    bool errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) const override;

public:

    Response(ymod_webserver::response_ptr s)
        : http_api::Response(std::move(s))
    { }

    using http_api::Response::with;
    void with(SearchCreateResult&& resp) const;
    void with(SearchShowResult&& resp) const;
    void with(SearchListResult&& resp) const;
    void with(SearchLastIdResult&& resp) const;
    void with(OrganizationShowResult&& resp) const;
    void with(MessagesBySearchResult&& resp) const;
    void with(MessagesBySearchAsyncResult&& resp) const;
    void with(JsonProxyResult&& resp) const;
    void with(ActionHistoryResult&& resp) const;
};

}
