#include <mail/spaniel/http_api/include/parse.h>
#include <mail/spaniel/core/include/types_reflection.h>
#include <yamail/data/deserialization/urlencoded_reader.h>
#include <mail/webmail/http_api_helpers/include/error.h>


namespace spaniel {

namespace ydd = yamail::data::deserialization;

namespace {
template<class T>
inline auto wrap(T&& fn) {
    try {
        fn();
    } catch (const ydd::urlencoded::ReaderException& ex) {
        http_api::Context::throwMissingParamException(ex.what());
    }
}

template<class Type>
Type parse(const http_api::Context& ctx) {
    Type variableToFill;
    const auto extractOneArg   = [&] (auto&& name) { return ctx.optionalArg(name);  };
    const auto extractManyArgs = [&] (auto&& name) { return ctx.optionalArgs(name); };

    wrap([&] () {
        ydd::fromUrlencoded(variableToFill, extractOneArg, extractManyArgs);
    });

    return variableToFill;
}
}

SearchShowParams parseSearchShowParams(const http_api::Context& ctx) {
    return parse<SearchShowParams>(ctx);
}

SearchArchiveParams parseSearchArchiveParams(const http_api::Context& ctx) {
    return parse<SearchArchiveParams>(ctx);
}

SearchListParams parseSearchListParams(const http_api::Context& ctx) {
    return parse<SearchListParams>(ctx);
}

struct SearchCreateParamsFromArgs {
    std::optional<Query> query_params;
    std::optional<SearchName> name;
    std::time_t date_from;
    std::time_t date_to;
};

SearchCreateParams parseSearchCreateParams(const http_api::Context& ctx) {
    auto parsed = parse<SearchCreateParamsFromArgs>(ctx);

    return SearchCreateParams {
        .queryParams = parsed.query_params ? std::move(*parsed.query_params) : Query(),
        .name = std::move(parsed.name),
        .dateFrom = parsed.date_from,
        .dateTo = parsed.date_to
    };
}

SearchRenameParams parseSearchRenameParams(const http_api::Context& ctx) {
    return parse<SearchRenameParams>(ctx);
}

MessagesBySearchAndUidParams parseMessagesBySearchAndUidParams(const http_api::Context& ctx) {
    return parse<MessagesBySearchAndUidParams>(ctx);
}

MessagesBySearchParams parseMessagesBySearchParams(const http_api::Context& ctx) {
    return parse<MessagesBySearchParams>(ctx);
}

ActionHistoryParams parseActionHistoryParams(const http_api::Context& ctx) {
    return parse<ActionHistoryParams>(ctx);
}

SendShareParams parseSendShareParams(const http_api::Context& ctx) {
    return parse<SendShareParams>(ctx);
}


MessagesAccessParams parseMessagesAccessParams(const http_api::Context& ctx) {
    return parse<MessagesAccessParams>(ctx);
}

SingleMessageAccessParams parseSingleMessageAccessParams(const http_api::Context& ctx) {
    return parse<SingleMessageAccessParams>(ctx);
}

}

YREFLECTION_ADAPT_ADT(spaniel::ResolveUsers,
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Departments>, exclude_departments, excludeDepartments)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Departments>, include_departments, includeDepartments)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Uids>, exclude_uids, excludeUids)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Uids>, include_uids, includeUids)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Groups>, exclude_groups, excludeGroups)
    YREFLECTION_MEMBER_RENAMED(std::optional<spaniel::Groups>, include_groups, includeGroups)
)

BOOST_FUSION_ADAPT_STRUCT(spaniel::SearchCreateParamsFromArgs, query_params, name, date_from, date_to)

YREFLECTION_ADAPT_ADT(spaniel::SearchShowParams,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
)

YREFLECTION_ADAPT_ADT(spaniel::SearchArchiveParams,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
)

BOOST_FUSION_ADAPT_STRUCT(spaniel::SearchListParams, page)

YREFLECTION_ADAPT_ADT(spaniel::SearchRenameParams,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(std::string, name)
)

YREFLECTION_ADAPT_ADT(spaniel::MessagesBySearchParams,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(spaniel::PageParams, page)
)

YREFLECTION_ADAPT_ADT(spaniel::MessagesBySearchAndUidParams,
    YREFLECTION_MEMBER_RENAMED(spaniel::SearchId, search_id, searchId)
    YREFLECTION_MEMBER(spaniel::PageParams, page)
    YREFLECTION_MEMBER(spaniel::Uid, uid)
)

BOOST_FUSION_ADAPT_STRUCT(spaniel::ActionHistoryParams, page)
