#!/bin/bash

export app=spaniel
export dog_name=spaniel

source /opt/service_sh/environment_type.sh
source /opt/service_sh/ephemerial.sh
source /opt/service_sh/push_client_to_ephemerial.sh push-client-spaniel-log
source /opt/service_sh/postgres.sh
source /opt/service_sh/tvm.sh
source /opt/service_sh/ssl.sh
source /opt/service_sh/link_common_files.sh
source /opt/service_sh/link_nginx_config.sh
source /opt/service_sh/link_push_client.sh

if [[ "${ENVIRONMENT}" == "testing" ]]; then
    ln -sf /etc/push-client/push-client-$app-log.yaml-${ENVIRONMENT} /etc/push-client/push-client-$app-log.yaml
fi

if [[ "${QA_ENVIRONMENT}" == "true" ]]; then
    rm /etc/spaniel/spaniel.yml

    QLOUD_FULL_ENV=$(echo ${QLOUD_DISCOVERY_COMPONENT} | grep -o -P '(?<=spaniel.).+')
    QUEUE_DB_HOST="queuedb-1.queuedb.${QLOUD_FULL_ENV}"
    SPANIEL_DB_HOST="spanieldb-1.spanieldb.${QLOUD_FULL_ENV}"

    sed -i -e "1 s#^#${QUEUE_DB_HOST}:6432:queuedb:spaniel:gavgav\n#;" /home/wmi/.pgpass
    sed -i -e "1 s#^#${SPANIEL_DB_HOST}:6432:spanieldb:spaniel:gavgav\n#;" /home/wmi/.pgpass

    sed -e "s#_QUEUE_DB_HOST_#${QUEUE_DB_HOST}#g" \
        -e "s#_SPANIEL_DB_HOST_#${SPANIEL_DB_HOST}#g" \
        /etc/spaniel/spaniel-qa-patch.yml > /etc/spaniel/spaniel.yml

    ln -sf /etc/spaniel/spaniel.yml-${ENVIRONMENT} /etc/spaniel/spaniel-base.yml
else
    ln -sf /etc/spaniel/spaniel.yml-${ENVIRONMENT} /etc/spaniel/spaniel.yml
fi

ln -sf /etc/nginx/sites-available/service.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/service.conf
ln -sf /etc/nginx/sites-available/service.include /etc/nginx/sites-enabled/service.include
ln -sf /etc/nginx/sites-available/log_by_lua.include /etc/nginx/sites-enabled/log_by_lua.include
