#include <mail/spaniel/service/include/handlers/action_history.h>


namespace spaniel {

yamail::expected<ActionHistoryResult> actionHistory(CommonParams common, ActionHistoryParams params,
                                                    ConfigPtr cfg, boost::asio::yield_context yield) {

    auto range = cfg->repo->getActionHistory(
        common, params.page, io_result::make_yield_context(yield)
    );

    ActionHistoryResult res;
    std::copy(std::make_move_iterator(range.begin()), std::make_move_iterator(range.end()), std::back_inserter(res.data));
    if (!res.data.empty()) {
        res.next = std::to_string(res.data.back().actionId.t);
    }

    return res;
}

}
