#include <mail/spaniel/service/include/handlers/attach_sid.h>
#include <mail/spaniel/service/include/proxy_helpers.h>
#include <mail/spaniel/service/include/request.h>

namespace spaniel {

yamail::expected<FilterSearchResult> attachSid(CommonParams common, SingleMessageAccessParams ma,
                                               RequestContext req, ConfigPtr cfg,
                                               const http_api::Context& ctx, boost::asio::yield_context yield) {
    checkMessageAccess(common, ma, cfg, yield);

    return doProxyGetRequest(makeProxyArgs(ctx.req->raw_url), makeProxyHeaders(ctx, proxyHeadersWithoutTickets),
                             req.client, cfg->attach_sid, Request::hound, RemoteServiceError::proxy, yield);
}

}
