#include <mail/spaniel/service/include/handlers/filter_search.h>
#include <mail/spaniel/service/include/proxy_helpers.h>
#include <mail/spaniel/service/include/request.h>

namespace spaniel {

yamail::expected<FilterSearchResult> filterSearch(CommonParams common, MessagesAccessParams ma,
                                                  RequestContext req, ConfigPtr cfg,
                                                  const http_api::Context& ctx, boost::asio::yield_context yield) {
    checkMessageAccess(common, ma, cfg, yield);

    return doProxyGetRequest(makeProxyArgs(ctx.req->raw_url), makeProxyHeaders(ctx, proxyHeadersWithoutTickets),
                             req.client, cfg->hound, Request::hound, RemoteServiceError::proxy, yield);
}

}
