#include <mail/spaniel/service/include/handlers/send_share.h>
#include <mail/spaniel/service/include/request.h>
#include <mail/spaniel/service/include/proxy_helpers.h>
#include <mail/spaniel/service/include/log_action.h>


namespace spaniel {

yamail::expected<SendShareResult> sendShare(CommonParams common, SingleMessageAccessParams ma, SendShareParams params,
                                            RequestContext req, ConfigPtr cfg, const http_api::Context& ctx,
                                            boost::asio::yield_context yield) {
    
    checkMessageAccess(common, ma, cfg, yield);

    log_action::sendShare(std::move(params), std::move(ma), common, cfg, yield);

    return doProxyPostRequest(makeProxyArgs(ctx.req->raw_url), makeProxyHeaders(ctx, proxyHeadersWithoutTickets), ctx.body(),
                              req.client, cfg->sendbernar, Request::sendbernar, RemoteServiceError::proxy, yield);
}

}
