#include <mail/spaniel/service/include/handlers/user.h>
#include <mail/webmail/corgi/include/resolve/blackbox.h>
#include <mail/spaniel/service/include/request.h>
#include <mail/spaniel/core/include/types_error.h>


namespace spaniel {

using namespace http_getter::detail::operators;

yamail::expected<UserSettingResult> enableUser(const std::string& uid, const HttpArguments& args,
                                               http_getter::TypedClientPtr client,
                                               ConfigPtr cfg, boost::asio::yield_context yield) {
    bool ok = false;
    const auto handler = http_getter::withDefaultHttpWrap([&] (yhttp::response) { ok = true; });
    const auto yy = io_result::make_yield_context(yield);

    client->req(
        client->toPOST(cfg->createHiddenTrash).getArgs("uid"_arg=uid)
    )->call(Request::create_hidden_trash, handler, yy);

    if (!ok) {
        return make_unexpected(corgi::UnexpectedError::exception, "cannot create hidden trash");
    }

    ok = false;
    client->req(
        client->toPOST(cfg->settings).getArgs("args"_arg=args)
    )->call(Request::settings, handler, yy);

    if (!ok) {
        return make_unexpected(corgi::UnexpectedError::exception, "cannot set settings");
    }

    return yamail::expected<UserSettingResult>();
}

yamail::expected<UserSettingResult> disableUser(const std::string& uid, const HttpArguments& args,
                                                http_getter::TypedClientPtr client,
                                                ConfigPtr cfg, boost::asio::yield_context yield) {
    bool ok = false;
    const auto handler = http_getter::withDefaultHttpWrap([&] (yhttp::response) { ok = true; });
    const auto yy = io_result::make_yield_context(yield);

    client->req(
        client->toPOST(cfg->settings).getArgs("args"_arg=args)
    )->call(Request::settings, handler, yy);

    if (!ok) {
        return make_unexpected(corgi::UnexpectedError::exception, "cannot unset settings");
    }

    ok = false;
    client->req(
        client->toPOST(cfg->purgeHiddenTrash).getArgs("uid"_arg=uid)
    )->call(Request::purge_hidden_trash, handler, yy);

    if (!ok) {
        return make_unexpected(corgi::UnexpectedError::exception, "cannot purge hidden trash");
    }

    return yamail::expected<UserSettingResult>();
}

yamail::expected<UserSettingResult> userDisableEnable(bool enable, SettingParams params,
                                                      http_getter::TypedClientPtr client,
                                                      ConfigPtr cfg, boost::asio::yield_context yield) {

    UidsSet pdd = corgi::pddUids({params.uid}, *client, cfg->resolverConfig, yield).value_or_throw();
    if (pdd.empty()) {
        return UserSettingResult();
    }

    const std::string val = enable ? "on" : "";
    const std::string uid = std::to_string(params.uid.t);
    HttpArguments args;
    args.add("mail_b2b_admin_search_allowed", val);
    args.add("mail_b2b_admin_search_enabled", val);
    args.add("uid", uid);

    const auto action = enable ? enableUser : disableUser;
    return action (uid, args, client, cfg, yield);
}

}
