#include <mail/spaniel/service/include/hound.h>
#include <mail/webmail/corgi/include/trycatch.h>
#include <mail/spaniel/service/include/request.h>
#include <mail/spaniel/core/include/types_error.h>

#include <yamail/data/deserialization/json_reader.h>

BOOST_FUSION_DEFINE_STRUCT((spaniel::hound), Error,
    (int, code)
    (std::string, message)
    (std::string, reason)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel::hound), ErrorResponse,
    (spaniel::hound::Error, error)
)

namespace {

template <typename T>
std::optional<T> tryFromJson(const std::string& json) {
    try {
        return yamail::data::deserialization::fromJson<T>(json);
    } catch (const std::exception&) {
        return std::nullopt;
    }
}

}

namespace spaniel::hound {

yamail::expected<std::string> filterSearch(const Uid& uid,
                                           const std::vector<Id>& mids,
                                           const http_getter::TypedClient& client,
                                           const http_getter::TypedEndpoint& hound,
                                           boost::asio::yield_context yield) {
    yamail::expected<std::string> result = make_unexpected(RemoteServiceError::proxy, "unknown error");

    const auto handler = http_getter::withDefaultHttpWrap([&] (yhttp::response response) {
        trycatch(result, [&] () {
            if (!http_getter::helpers::successCode(response.status)) {
                result = make_unexpected(RemoteServiceError::proxy, response.body);
                return;
            }

            if (auto errorOpt = tryFromJson<ErrorResponse>(response.body)) {
                result = make_unexpected(RemoteServiceError::proxy, response.body);
                return;
            }

            result = response.body;
        });
        return result ? http_getter::Result::success : http_getter::Result::retry;
    });

    using namespace http_getter::detail::operators;

    HttpArguments midsArgs;
    midsArgs.arguments["mids"].reserve(mids.size());
    for (auto& mid: mids) {
        midsArgs.arguments["mids"].emplace_back(std::to_string(mid));
    }

    auto req = client.toGET(hound)
            .getArgs("uid"_arg=std::to_string(uid), "mids"_arg=midsArgs)
    ;

    client.req(std::move(req))
            ->call(Request::hound, handler, io_result::make_yield_context(yield));

    return result;
}

}
