#pragma once

#include <mail/spaniel/ymod_db/include/repository.h>
#include <mail/webmail/corgi/include/resolve/auth.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/ymod_queuedb/include/queue.h>


namespace spaniel {

struct Config {
    http_getter::TypedModulePtr getter;
    corgi::ResolverConfig resolverConfig;
    http_getter::TypedEndpoint hound;
    http_getter::TypedEndpoint attach_sid;
    http_getter::TypedEndpoint mbody;
    http_getter::TypedEndpoint sendbernar;
    http_getter::TypedEndpoint syncSearch;
    http_getter::TypedEndpoint settings;
    http_getter::TypedEndpoint createHiddenTrash;
    http_getter::TypedEndpoint purgeHiddenTrash;
    ymod_queuedb::Timeout asyncSearchTaskTimeout;
    ymod_queuedb::Timeout ogranizationUpdateAllTaskTimeout;
    ymod_queuedb::Timeout ogranizationSwitchTaskTimeout;
    RepositoryPtr repo;
    ymod_queuedb::QueuePtr queuedb;
    std::time_t intervalBeforeRemovingOrganization = 0;
};
using ConfigPtr = std::shared_ptr<Config>;

struct WorkerConfig {
    http_getter::TypedEndpoint search;
    http_getter::TypedEndpoint enableUser;
    http_getter::TypedEndpoint billing;
    unsigned asyncSearchResultLength;
    corgi::ResolverConfig resolverConfig;
    RepositoryPtr repo;
    ymod_queuedb::QueuePtr queuedb;
    ymod_queuedb::Timeout ogranizationUpdateTaskTimeout;
    std::time_t intervalBeforeRemovingOrganization = 0;
};
using WorkerConfigPtr = std::shared_ptr<WorkerConfig>;

}
