#pragma once

#include <mail/spaniel/core/include/types.h>
#include <mail/spaniel/service/include/result.h>
#include <mail/spaniel/service/include/request_context.h>

namespace spaniel {

yamail::expected<OrganizationEnableResult> organizationEnable(OrganizationParams common, ConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationActivateResult> organizationActivate(CommonParams common, ConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationShowResult> organizationShow(OrganizationParams common, ConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationDisableResult> organizationDisable(OrganizationParams common, ConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationDeactivateResult> organizationDeactivate(CommonParams common, ConfigPtr cfg, boost::asio::yield_context yield);

inline ymod_queuedb::TaskType organizationActivateType() {
    return ymod_queuedb::TaskType("organization_activate");
}

inline ymod_queuedb::TaskType organizationDeactivateType() {
    return ymod_queuedb::TaskType("organization_deactivate");
}

inline ymod_queuedb::TaskType organizationUpdateType() {
    return ymod_queuedb::TaskType("organization_update");
}

inline ymod_queuedb::TaskType organizationUpdateAllType() {
    return ymod_queuedb::TaskType("organization_update_all");
}

yamail::expected<void> organizationActivateDeactivateTask(bool activate, OrganizationParams common, SwitchOrganizationParams params,
                                                          WorkerRequestContext req, WorkerConfigPtr cfg, bool lastTry,
                                                          yplatform::task_context_ptr ctx, boost::asio::yield_context yield);

yamail::expected<void> organizationUpdate(OrganizationParams common, OrganizationResolverWithoutAdminUid resolver,
                                          WorkerConfigPtr cfg, yplatform::task_context_ptr ctx, boost::asio::yield_context yield);

yamail::expected<void> organizationUpdateAll(const RequestId& requestId, http_getter::TypedClientPtr client, WorkerConfigPtr cfg, yplatform::task_context_ptr ctx, boost::asio::yield_context yield);
yamail::expected<EmptyResult> organizationUpdateAll(const RequestId& requestId, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<void> organizationUpdate(OrganizationParams common, OrganizationUpdateParams params, WorkerRequestContext req,
                                          WorkerConfigPtr cfg, yplatform::task_context_ptr ctx, boost::asio::yield_context yield);

}
