#pragma once

#include <mail/spaniel/core/include/types.h>
#include <mail/spaniel/service/include/result.h>
#include <mail/spaniel/service/include/request_context.h>

namespace spaniel {
namespace detail {
void addSearchTask(const CommonParams& common, SearchId searchId, std::time_t dateFrom, std::time_t dateTo,
                   ConfigPtr cfg, ContextLogger logger, boost::asio::yield_context yield);
}


inline ymod_queuedb::TaskType asyncSearchType() {
    return ymod_queuedb::TaskType("async_search");
}

yamail::expected<void> asyncSearch(CommonParams common, AsyncSearchParams params,
                                   WorkerRequestContext req, WorkerConfigPtr cfg, const ymod_queuedb::ExecOrWait& eow,
                                   bool lastTry, yplatform::task_context_ptr ctx, boost::asio::yield_context yield);

yamail::expected<SearchCreateResult> searchCreate(CommonParams common, SearchCreateParams params,
                                                  RequestContext req, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<SearchShowResult> searchShow(CommonParams common, SearchShowParams params, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<SearchListResult> searchList(CommonParams common, SearchListParams params, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<SearchLastIdResult> searchLastId(CommonParams common, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<SearchArchiveResult> searchArchive(CommonParams common, SearchArchiveParams params, ConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<SearchRenameResult> searchRename(CommonParams common, SearchRenameParams params, ConfigPtr cfg, boost::asio::yield_context yield);

}
