#pragma once

#include <mail/webmail/http_api_helpers/include/context.h>
#include <mail/butil/include/butil/http/arguments.h>
#include <mail/butil/include/butil/http/headers.h>
#include <mail/spaniel/service/include/result.h>
#include <mail/http_getter/client/include/client.h>
#include <mail/spaniel/service/include/request.h>
#include <mail/spaniel/core/include/types_error.h>



namespace spaniel {

HttpArguments makeProxyArgs(const std::string& url);

http::headers makeProxyHeaders(const http_api::Context& ctx, std::function<bool(const std::string&)> filter);

bool proxyHeadersWithoutTickets(const std::string& s);

yamail::expected<JsonProxyResult> doProxyGetRequest(HttpArguments args, http::headers headers, http_getter::TypedClientPtr client, 
                                                    const http_getter::TypedEndpoint& ep, Request requestType,
                                                    RemoteServiceError defaultError, boost::asio::yield_context yield);

yamail::expected<JsonProxyResult> doProxyPostRequest(HttpArguments args, http::headers headers, std::string body,
                                                     http_getter::TypedClientPtr client, const http_getter::TypedEndpoint& ep,
                                                     Request requestType, RemoteServiceError defaultError,
                                                     boost::asio::yield_context yield);

}
