#pragma once

#include <mail/spaniel/service/include/config.h>
#include <mail/spaniel/core/include/log.h>
#include <mail/ymod_queuedb_worker/include/exec_or_wait.h>
#include <mail/http_getter/client/include/client.h>
#include <mail/spaniel/service/include/message_access.h>


namespace spaniel {

struct RequestContext {
    http_getter::TypedClientPtr client;
    OrganizationResolver orgResolver;
    ContextLogger logger;

    RequestContext(http_getter::TypedClientPtr clt, ConfigPtr cfg, const CommonParams& common)
        : client(std::move(clt))
        , orgResolver(cfg->resolverConfig, client, common)
        , logger(getContextLogger(common))
    { }
};

struct WorkerRequestContext {
    http_getter::TypedClientPtr client;
    ContextLogger logger;

    WorkerRequestContext(http_getter::TypedClientPtr clt, const CommonParams& common)
        : client(std::move(clt))
        , logger(getContextLogger(common))
    { }

    WorkerRequestContext(http_getter::TypedClientPtr clt, const OrganizationParams& common)
        : client(std::move(clt))
        , logger(getContextLogger(common))
    { }
};

}
