#pragma once

#include <yamail/expected.h>
#include <mail/spaniel/core/include/types.h>
#include <mail/ymod_webserver/include/ymod_webserver/codes.h>
#include <mail/webmail/http_api_helpers/include/result.h>
#include <macs/types.h>

#include <unordered_map>

namespace spaniel {

struct JsonProxyResult {
    ymod_webserver::codes::code code;
    std::string body;
    std::unordered_multimap<std::string, std::string> headers;
};

using FilterSearchResult = JsonProxyResult;
using AttachSidResult = JsonProxyResult;
using SendShareResult = JsonProxyResult;
using MessageResult = JsonProxyResult;

struct SearchCreateResult {
    SearchId search_id;
};

struct SearchLastIdResult {
    std::optional<SearchId> search_id;
};

using SearchShowResult = Search;
struct SearchListResult {
    std::vector<Search> data;
    PageParams::From next;
};

struct OrganizationShowResult {
    boost::optional<OrganizationState> state;
};

using http_api::EmptyResult;
using OrganizationEnableResult = EmptyResult;
using OrganizationUpdateResult = EmptyResult;
using OrganizationDisableResult = EmptyResult;
using OrganizationActivateResult = EmptyResult;
using OrganizationDeactivateResult = EmptyResult;
using SearchRenameResult = EmptyResult;
using SearchArchiveResult = EmptyResult;

using UserSettingResult = EmptyResult;

struct MessagesBySearchResult {
    std::map<Uid, std::string> data;
    PageParams::From next;
};

using MessagesBySearchAsyncResult = std::variant<MessagesBySearchResult, SearchCreateResult>;

struct ActionHistoryResult {
    std::vector<ActionHistoryItem> data;
    PageParams::From next;
};

}
