#pragma once

#include <mail/spaniel/core/include/types.h>
#include <mail/http_getter/client/include/client.h>
#include <mail/spaniel/service/include/request.h>


namespace spaniel {
namespace detail {

using RequestResults = std::function<void(const MailSearchCommonParams&, SearchResults&)>;

constexpr unsigned ADDITIONAL_SEARCH_RESULTS = 5;
constexpr unsigned PAGE_LENGTH_FOR_LOADING_RESULTS = 30;

bool comparator(const SearchResult& lhs, const SearchResult& rhs);
std::optional<std::time_t> extractNextFromSequence(const SearchResults& results, std::size_t requestedSize);
SearchResults requestFullPageOfResults(std::time_t date, const RequestResults& makeResults);
SearchResults search(const MailSearchCommonParams& params, const RequestResults& requestResults);

}


SearchResults makeSearch(const Search& search, const MailSearchCommonParams& params, const http_getter::TypedClient& client,
                         const http_getter::TypedEndpoint& endpoint, Request requestType, boost::asio::yield_context yield);

SearchResults makeSearch(const Search& search, Uid uid, const MailSearchCommonParams& params, const http_getter::TypedClient& client,
                         const http_getter::TypedEndpoint& endpoint, Request requestType, boost::asio::yield_context yield);

}
