#include <mail/spaniel/service/include/log_action.h>
#include <mail/spaniel/core/include/types_reflection.h>
#include <yamail/data/serialization/yajl.h>


namespace spaniel::log_action {

void sendShare(SendShareParams logParams, SingleMessageAccessParams ma, const CommonParams& common, const ConfigPtr& cfg, boost::asio::yield_context yield) {
    using yamail::data::serialization::toJson;

    const auto yy = io_result::make_yield_context(yield);
    cfg->repo->logAction(
        common, ActionHistoryType::send_share,
        toJson(spaniel::ActionHistoryInfo {
            .sendShare = spaniel::ActionHistoryInfo::SendShare {
               .to = std::move(logParams.to),
               .uid = std::move(ma.uid),
               .mid = std::move(ma.mid),
               .searchId = std::move(ma.searchId)
            }
        }), yy
    );
}

}
