#include <mail/spaniel/service/include/message_access.h>
#include <mail/webmail/corgi/include/types_error.h>


namespace spaniel {

template<class MessageAccessParams>
void checkMessageAccessImpl(const CommonParams& common, const MessageAccessParams& ma,
                            ConfigPtr cfg, boost::asio::yield_context yield) {
    if (!cfg->repo->messagesInSearch(common, ma, io_result::make_yield_context(yield))) {
        throw mail_errors::system_error(
            make_error(
                corgi::AccessError::accessDenied,
                fmt::format("no such ids in search_id: {}", ma.searchId.t)
            )
        );
    }
}

void checkMessageAccess(const CommonParams& common, const SingleMessageAccessParams& ma,
                        ConfigPtr cfg, boost::asio::yield_context yield) {
    checkMessageAccessImpl(common, ma, cfg, yield);
}

void checkMessageAccess(const CommonParams& common, const MessagesAccessParams& ma,
                        ConfigPtr cfg, boost::asio::yield_context yield) {
    checkMessageAccessImpl(common, ma, cfg, yield);
}

}
