#include <mail/spaniel/service/include/task_params.h>
#include <mail/spaniel/core/include/types_reflection.h>
#include <mail/spaniel/core/include/log.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <yamail/data/deserialization/json_reader.h>
#include <yamail/data/serialization/json_writer.h>


BOOST_FUSION_ADAPT_STRUCT(spaniel::AsyncSearchParams, searchId, dateFrom, dateTo)
BOOST_FUSION_ADAPT_STRUCT(spaniel::OrganizationUpdateParams, all, newbie)
BOOST_FUSION_DEFINE_STRUCT((spaniel), OrganizationUpdateAllParams,
    (corgi::RequestId, requestId)
)


namespace spaniel {

namespace yds = yamail::data::serialization;
namespace ydd = yamail::data::deserialization;

template<class Params, class AnotherParams>
ymod_queuedb::TaskArgs dumpParams(const Params& common, const AnotherParams& params) {
    return ymod_queuedb::TaskArgs(std::make_optional(yds::JsonWriter(std::make_pair(common, params)).result()));
}

template<class Params, class AnotherParams>
std::pair<Params, AnotherParams> parseParams(const ymod_queuedb::Task& task) {
    return ydd::JsonReader<std::pair<Params, AnotherParams>>(task.taskArgs).result();
}

ymod_queuedb::TaskArgs dumpOrganizationParams(const OrganizationParams& common) {
    return ymod_queuedb::TaskArgs(std::make_optional(yds::JsonWriter(common).result()));
}

std::pair<OrganizationParams, SwitchOrganizationParams> parseOrganizationSwitchParams(const ymod_queuedb::Task& task) {
    auto common = ydd::JsonReader<OrganizationParams>(task.taskArgs).result();
    SwitchOrganizationParams params {.taskId = task.taskId};

    return std::make_pair(std::move(common), std::move(params));
}

ymod_queuedb::TaskArgs dumpOrganizationUpdateParams(const OrganizationParams& common, const OrganizationUpdateParams& params) {
    return dumpParams(common, params);
}

std::pair<OrganizationParams, OrganizationUpdateParams> parseOrganizationUpdateParams(const ymod_queuedb::Task& task) {
    return parseParams<OrganizationParams, OrganizationUpdateParams>(task);
}

ymod_queuedb::TaskArgs dumpAsyncSearchParams(const CommonParams& common, const AsyncSearchParams& params) {
    return dumpParams(common, params);
}

std::pair<CommonParams, AsyncSearchParams> parseAsyncSearchParams(const ymod_queuedb::Task& task) {
    return parseParams<CommonParams, AsyncSearchParams>(task);
}

ymod_queuedb::TaskArgs dumpOrganizationUpdateAllParams(const RequestId& reqId) {
    return ymod_queuedb::TaskArgs(std::make_optional(yds::JsonWriter(OrganizationUpdateAllParams(reqId)).result()));
}

RequestId parseOrganizationUpdateAllParams(const ymod_queuedb::Task& task) {
    return ydd::JsonReader<OrganizationUpdateAllParams>(task.taskArgs).result().requestId;
}

}
