#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>


namespace spaniel::reflection {
struct SearchResult {
    std::int64_t uid;
    std::int64_t id;
    std::time_t received_date;
};
using SearchResultVec = std::vector<SearchResult>;

using UidVec = std::vector<std::int64_t>;
using IdVec = std::vector<std::int64_t>;
struct RequestInfo {
    std::int64_t orgId;
    std::int64_t uid;
    std::string requestId;

    RequestInfo() = default;
    RequestInfo(const CommonParams& c)
        : orgId(c.orgId)
        , uid(c.adminUid)
        , requestId(c.requestId)
    { }
};
}

BOOST_FUSION_ADAPT_STRUCT(spaniel::reflection::RequestInfo,
    orgId,
    uid,
    requestId,
)

BOOST_FUSION_ADAPT_STRUCT(spaniel::reflection::SearchResult,
    uid,
    id,
    received_date
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), SearchId,
    (std::int64_t, search_id)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), OptionalSearchId,
    (boost::optional<std::int64_t>, search_id)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), Search,
    (std::int64_t, org_id)
    (std::int64_t, search_id)
    (std::int64_t, admin_uid)
    (std::vector<std::int64_t>, requested_uids)
    (boost::optional<std::vector<std::int64_t>>, found_uids)
    (std::string, query)
    (std::string, state)
    (std::string, name)
    (std::time_t, date_from)
    (std::time_t, date_to)
    (std::time_t, created)
    (std::time_t, updated)
    (boost::optional<std::time_t>, min_search_date)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), OptionalSearch,
    (boost::optional<spaniel::reflection::Search>, search)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), OptionalOrgId,
    (boost::optional<std::int64_t>, orgId)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), Organization,
    (std::string, state)
    (std::time_t, doom_date)
    (std::time_t, created)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), WithUid,
   (std::int64_t, uid)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), WithOrgId,
   (std::int64_t, org_id)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), OptionalOrganization,
   (boost::optional<spaniel::reflection::Organization>, organization)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), WithSearch,
    (spaniel::reflection::Search, search)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), WithResult,
    (boost::optional<std::string>, result)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), WithBool,
    (bool, result)
)

PGG_QUERY_ID((spaniel)(query), Uid, std::int64_t)
PGG_QUERY_ID((spaniel)(query), OrgId, std::int64_t)
PGG_QUERY_ID((spaniel)(query), SearchId, std::int64_t)
PGG_QUERY_ID((spaniel)(query), TaskId, ymod_queuedb::TaskId)
PGG_QUERY_ID((spaniel)(query), QueryJson, std::string)
PGG_QUERY_ID((spaniel)(query), Name, std::string)
PGG_QUERY_ID((spaniel)(query), UidVec, spaniel::reflection::UidVec)
PGG_QUERY_ID((spaniel)(query), IdVec, spaniel::reflection::IdVec)
PGG_QUERY_ID((spaniel)(query), SearchResultVec, spaniel::reflection::SearchResultVec)
PGG_QUERY_ID((spaniel)(query), RequestInfo, spaniel::reflection::RequestInfo)
PGG_QUERY_ID((spaniel)(query), Notice, std::string)
PGG_QUERY_ID((spaniel)(query), DateFrom, std::time_t)
PGG_QUERY_ID((spaniel)(query), DateTo, std::time_t)
PGG_QUERY_ID((spaniel)(query), Date, std::time_t)
PGG_QUERY_ID((spaniel)(query), RowCount, std::uint64_t)
PGG_QUERY_ID((spaniel)(query), RowFrom, std::int64_t)
PGG_QUERY_ID((spaniel)(query), SearchState, std::string)
PGG_QUERY_ID((spaniel)(query), InfoJson, std::string)
PGG_QUERY_ID((spaniel)(query), ActionType, std::string)
PGG_QUERY_ID((spaniel)(query), DoomDate, std::time_t)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), ReceivedDate,
    (std::time_t, received_date)
)

BOOST_FUSION_DEFINE_STRUCT((spaniel)(reflection), ActionHistoryRow,
    (std::int64_t, action_id)
    (std::int64_t, admin_uid)
    (std::time_t, date)
    (std::string, info)
    (std::string, type)
)

namespace spaniel::query {

struct ReserveSearchId: pgg::query::QueryImpl<ReserveSearchId, OrgId> {
    using Inherited::Inherited;
};

struct CreateSearch: pgg::query::QueryImpl<CreateSearch, SearchId, QueryJson, Name, UidVec, DateFrom, DateTo, RequestInfo> {
    using Inherited::Inherited;
};

struct FillSearch: pgg::query::QueryImpl<FillSearch, SearchId, SearchResultVec, SearchState, RequestInfo> {
    using Inherited::Inherited;
};

struct CacheSearchResults: pgg::query::QueryImpl<CacheSearchResults, SearchId, SearchResultVec, RequestInfo> {
    using Inherited::Inherited;
};

struct SearchById: pgg::query::QueryImpl<SearchById, OrgId, SearchId> {
    using Inherited::Inherited;
};

struct SearchList: pgg::query::QueryImpl<SearchList, OrgId, RowCount, RowFrom> {
    using Inherited::Inherited;
};

struct FailSearch: pgg::query::QueryImpl<FailSearch, SearchId, Notice, RequestInfo> {
    using Inherited::Inherited;
};

struct ContinueSearch: pgg::query::QueryImpl<ContinueSearch, SearchId, RequestInfo> {
    using Inherited::Inherited;
};

struct LastSearchId: pgg::query::QueryImpl<LastSearchId, OrgId> {
    using Inherited::Inherited;
};

struct SearchByOneUser: pgg::query::QueryImpl<SearchByOneUser, OrgId, SearchId, Uid, RowFrom, RowCount> {
    using Inherited::Inherited;
};

struct SearchByAllUsers: pgg::query::QueryImpl<SearchByAllUsers, OrgId, SearchId, RowFrom, RowCount> {
    using Inherited::Inherited;
};

struct SearchRename: pgg::query::QueryImpl<SearchRename, OrgId, SearchId, Name> {
    using Inherited::Inherited;
};

struct ArchiveSearch: pgg::query::QueryImpl<ArchiveSearch, SearchId, RequestInfo> {
    using Inherited::Inherited;
};

struct MinReceivedDateBySearchAndUid: pgg::query::QueryImpl<MinReceivedDateBySearchAndUid, OrgId, SearchId, Uid> {
    using Inherited::Inherited;
};

struct DisableOrganization: pgg::query::QueryImpl<DisableOrganization, OrgId, DoomDate> {
    using Inherited::Inherited;
};

struct ActivateOrganization: pgg::query::QueryImpl<ActivateOrganization, OrgId> {
    using Inherited::Inherited;
};

struct DeactivateOrganization: pgg::query::QueryImpl<DeactivateOrganization, OrgId, DoomDate> {
    using Inherited::Inherited;
};

struct GetOrganization: pgg::query::QueryImpl<GetOrganization, OrgId> {
    using Inherited::Inherited;
};

struct LogAction: pgg::query::QueryImpl<LogAction, ActionType, RequestInfo, InfoJson> {
    using Inherited::Inherited;
};

struct GetActionHistory: pgg::query::QueryImpl<GetActionHistory, OrgId, RowFrom, RowCount> {
    using Inherited::Inherited;
};

struct MessagesInSearch: pgg::query::QueryImpl<MessagesInSearch, OrgId, SearchId, Uid, IdVec> {
    using Inherited::Inherited;
};

struct GetOrganizationUids: pgg::query::QueryImpl<GetOrganizationUids, OrgId> {
    using Inherited::Inherited;
};

struct UpdateOrganizationUids: pgg::query::QueryImpl<UpdateOrganizationUids, OrgId, UidVec> {
    using Inherited::Inherited;
};

struct ListActiveOrganizationIds: pgg::query::QueryImpl<ListActiveOrganizationIds> {
    using Inherited::Inherited;
};

struct RegisterTaskId: pgg::query::QueryImpl<RegisterTaskId, OrgId, TaskId> {
    using Inherited::Inherited;
};

struct RemoveTaskId: pgg::query::QueryImpl<RemoveTaskId, OrgId, TaskId> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
    GetActionHistory,
    LogAction,
    ReserveSearchId,
    MessagesInSearch,
    CreateSearch,
    LastSearchId,
    ArchiveSearch,
    FillSearch,
    CacheSearchResults,
    SearchById,
    FailSearch,
    ContinueSearch,
    SearchList,
    SearchByOneUser,
    SearchByAllUsers,
    SearchRename,
    MinReceivedDateBySearchAndUid,
    GetOrganizationUids,
    UpdateOrganizationUids,
    GetOrganization,
    ListActiveOrganizationIds,
    DisableOrganization,
    ActivateOrganization,
    DeactivateOrganization,
    RegisterTaskId,
    RemoveTaskId
>;

using ParametersRegister = pgg::query::RegisterParameters<>;

}
