import os

import yaml

from library.python import resource
from mail.devpack.lib import helpers
from mail.devpack.ctl.lib.main import wrap_main
from mail.devpack.lib.components.base import DogAppComponent, FakeRootComponent
from mail.webmail_config.lib.make_config import make_config


class Consumer(DogAppComponent):
    NAME = 'sqbar'
    DEPS = []

    def __init__(self, env, components):
        super(Consumer, self).__init__(env, components, custom_path=f'{self.NAME}')

    def init_root(self):
        self.yhttp.init_root()

        helpers.write2file(resource.find(f'{self.NAME}/tvm_secret'), os.path.join(self.secrets_path, 'tvm_secret'))

        helpers.mkdir_recursive(os.path.join(self.get_root(), 'app', 'cache', 'tvm'))
        helpers.mkdir_recursive(os.path.join(self.get_root(), 'app', 'its_client', 'controls'))

        self._generate_config('development')
        devpack = self.yhttp.format_config(resource.find(f'{self.NAME}/local.yml'))
        helpers.write2file(devpack, os.path.join(self.config_path, 'config-devpack.yml'))

    def _generate_config(self, env):
        base = resource.find(f'{self.NAME}/config.yml')
        service_yaml = yaml.safe_load(resource.find(f'{self.NAME}/service.yaml'))
        common_yaml = yaml.safe_load(resource.find('webmail_config/common.yaml'))
        cfg = make_config(env, base, service_yaml, common_yaml, silent=True)
        config = self.yhttp.format_config(cfg)
        helpers.write2file(config, os.path.join(self.config_path, 'config.yml'))


class Service(FakeRootComponent):
    NAME = 'service'
    DEPS = [Consumer]


def main():
    wrap_main(deps_root=Service)
