#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>


namespace sqbar {
namespace log {
using namespace ::logdog::attr;
}

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-sqbar-tskv-log"));

inline auto getModuleLogger(const std::string& name) {
    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(yplatform::log::find(name, false))
    );
}

using ModuleLogger = decltype(getModuleLogger(""));

}
