#!/bin/bash

if [ -z $1 ];then
    echo "Usage:"
    echo $0" /dev/sdX"
    exit
fi

DISK=$1
SERIAL=$(hdparm -I $DISK | grep "Serial Number" | awk '{print $3}')

echo "All disks:"
lsscsi | grep -C 100 --color $DISK

echo -e "\nSlot:"
lsscsi | grep $DISK

echo -e "\nSerial Number:"
echo $SERIAL
