
#!/bin/bash

PATH=/bin:/sbin:/usr/bin:/usr/sbin

die() {
    echo "$1;$2"
    exit 0
}

stat_file="/proc/mdstat"
mdadm="sudo -n mdadm --detail"
err_code=0
message=""

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi


# Also take a look into /proc/mdstat
arrays="${arrays} $(awk '/^md[0-9pd_]+ :/ {print $1}' ${stat_file})"

# Remove duplicates
arrays=$(echo "${arrays}" | sed -e 's/ /\n/g' | sort | uniq)

for md in $arrays
do
    failed_count=$(${mdadm}  "/dev/${md}" | grep "Failed Devices" |  awk -F" : " '{ print $2 }')
    if [ "${failed_count}" -gt 0 ]; then
        err_code=2
        message=$message"failed devices: "$md":"$failed_count";"
        die $err_code "$message"
    fi
done
die $err_code "OK"

