#!/bin/bash

me=${0##*/} # strip path
me=${me%.*} # strip extension
lock="/tmp/${me}.lock"
reset_flag="/tmp/${me}.rst_flag"

die() {
    echo "$1;$2"
    exit 0
}

try_reset() {
    if [ -f "$reset_flag" ]
    then
        die 1 "ipmi failed"
    else
        touch "$reset_flag"
        die 1 "Resetting $(sudo ipmitool mc reset cold 2>&1)"
    fi
}

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi

if cat /proc/cpuinfo | grep 'model name' | grep -q 'KVM'
then
    die 0 "OK"
elif sudo grep /var/log/dmesg -e 'Booting paravirtualized kernel on KVM' -q 2>/dev/null
then
    die 0 "OK"
fi

if ! which ipmitool >/dev/null 2>&1
then
    die 1 "ipmitool not found"
fi

exec 200>"$lock"
flock -n 200 || try_reset
echo $$ >&200

RES=$(sudo ipmitool mc info 2>&1 | wc -l)
if [ "$RES" -gt 8 ]
then
    rm -rf "$lock" "$reset_flag"
    die 0 "OK"
else
    if [ -e /dev/ipmi0 ]
    then
        rm -rf "$lock"
        die 1 "ipmi failed"
    else
        rm -rf "$lock" "$reset_flag"
        die 0 "OK"
    fi
fi
