#!/bin/bash
TMP="/tmp"
current_load_rx=$(cat /sys/class/net/eth0/statistics/rx_bytes)
current_load_tx=$(cat /sys/class/net/eth0/statistics/tx_bytes)

while getopts "w:c:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT_DEF="$OPTARG"
        ;;
        c)
            CRIT_LIMIT_DEF="$OPTARG"
        ;;
    esac
done

WARN_LIMIT=${WARN_LIMIT_DEF:-60}
CRIT_LIMIT=${CRIT_LIMIT_DEF:-80}

if [ -s "/etc/default/network_usage" ]; then
	WARN_LIMIT=$(cat network_us:age_conf | grep [az] -v |  awk -F" " '{ print $1 }')
	CRIT_LIMIT=$(cat network_usage_conf | grep [az] -v |  awk -F" " '{ print $2 }')
fi

if [ -s "$TMP/if_load_old_temp.rx" ]; then
        old_load_rx=$(cat "$TMP/if_load_old_temp.rx")
    else
        old_load_rx=0
fi

echo "$current_load_rx" > "$TMP/if_load_old_temp.rx"


if [ -s "$TMP/if_load_old_temp.tx" ]; then
        old_load_tx=$(cat "$TMP/if_load_old_temp.tx")
    else
        old_load_tx=0
fi

echo "$current_load_tx" > "$TMP/if_load_old_temp.tx"

deltaload_rx=$(( current_load_rx - old_load_rx ))
deltaload_tx=$(( current_load_tx - old_load_tx ))

interface_speed=`sudo /sbin/ethtool eth0  2>/dev/null| awk '/Speed/ {print $2}' | rev | cut -c 5- | rev`
minute_traffic=$(( interface_speed  / 8 * 1024 * 1024 * 60)) # interface speed in bytes per  minute

load_perc_rx=$(( (deltaload_rx * 100)  / minute_traffic | bc ))
load_perc_tx=$(( (deltaload_tx * 100)  / minute_traffic  | bc ))

if [ $load_perc_rx  -gt $CRIT_LIMIT ]  ||  [ $load_perc_tx  -gt $CRIT_LIMIT ]; then
        status=2
elif [ $load_perc_rx  -gt $WARN_LIMIT ]  || [ $load_perc_tx  -gt $WARN_LIMIT ]; then
        status=1
else
        status=0
fi

echo "$status;rx=$load_perc_rx%, tx=$load_perc_tx%"
