#!/usr/bin/python
# -*- coding: UTF-8 -*-

from urllib2 import urlopen
import json
import re
import socket

MAP_64_URL = "https://racktables.yandex-team.ru/export/map64.json"

map_64 = json.loads(urlopen(MAP_64_URL).read())

hostname = socket.gethostname()

INTERFACE_TEMPLATE = """
auto tun0
iface tun0 inet manual
        ya-netconfig-disable yes
        pre-up ip -f inet6 tunnel add tun0 mode ipip6 remote 2a02:6b8:b010:a0ff::1 local addr6
        up ifconfig tun0 up mtu 1510
        post-up ip addr add addr4/32 dev tun0
        post-up ip route add 0/0 dev tun0 mtu lock 1450 advmss 1410
        pre-down ip route del 0/0 dev tun0 mtu lock 1450 advmss 1410
        pre-down ip addr del addr4/32 dev tun0
        pre-down ip -f inet6 tunnel del tun0
"""

for addr4, addr4_data in map_64.items():
    if addr4_data["fqdn"] == hostname:
        addr6 = addr4_data["addr6"]
        break

INTERFACE_TEMPLATE = re.sub("addr6", addr6, INTERFACE_TEMPLATE)
INTERFACE_TEMPLATE = re.sub("addr4", addr4, INTERFACE_TEMPLATE)

print INTERFACE_TEMPLATE
