#!/bin/bash

description="OK"
interfaces=""
status=0

ipv4_chains=$(iptables -S | grep "Hide from balancer" | awk '{print $2" "}' | sort | uniq | tr -d '\n')
if [ "$ipv4_chains" != "" ];then
    status=2;
    interfaces="IPv4:"$ipv4_chains";"
fi

ipv6_chains=$(ip6tables -S | grep "Hide from balancer" | awk '{print $2" "}' | sort | uniq | tr -d '\n')
if [ "$ipv6_chains" != "" ];then
    status=2;
    interfaces=$interfaces" IPv6:"$ipv6_chains
fi


if [ $status -eq 2 ];then
    description="rejected: "$interfaces
fi

echo $status";"$description
