#!/bin/bash

# нужны два токена - для джагглера и облака
export JUGGLER_OAUTH_TOKEN=`cat ~/.juggler.token`
export YC_TOKEN=`cat ~/.yc.token`

# folder, из которого будут получены трансферы
FOLDER_ID=foo8debsmodt2n1bj125

# нунен juggker-sdk
# python3 -m pip install --index-url https://pypi.yandex-team.ru/simple juggler-sdk

function apply_alert() {
    local transfer_id=$1
    local name=$2

    echo "transfer: $transfer_id name: $name"

    python3 -c 'import sys, yaml, json; from yaml import CLoader as Loader; json.dump(yaml.load(sys.stdin, Loader=Loader), sys.stdout, indent=2)' < ./template.yaml \
        | \
        sed "s/DT/$transfer_id/g" | \
        sed "s/NAME/$name/g" | \
        sed "s/FOLDER/$FOLDER_ID/g" | \
        juggler-sdk load -v --force --api https://juggler-api.search.yandex.net
}


function get_transfers() {
    curl --silent \
        "https://cdc.n.yandex-team.ru/v1/transfers/list/$FOLDER_ID?status=RUNNING" \
        -H "accept: application/json" \
        -H "Authorization: $YC_TOKEN" \
        -H "Content-Type: application/json" | jq -c ".transfers[]|[.id,.name]"
}

transfers=`get_transfers`

for transfer in ${transfers[@]}; do
    echo $transfer
    apply_alert `echo $transfer | jq -r .[0]` `echo $transfer | jq -r .[1]`
done
