CREATE TABLE logs._mail_api360_envoy_tskv_local ON CLUSTER 'active_logs'
(
    `date` MATERIALIZED toDate(`timestamp`) CODEC(DoubleDelta, LZ4),
    `timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `method` LowCardinality(String),
    `request` String CODEC(ZSTD(7)),
    `protocol` LowCardinality(String),
    `response_code` UInt16,
    `response_flags` String CODEC(ZSTD(7)),
    `bytes_received` UInt32,
    `bytes_sent` UInt32,
    `duration` UInt32,
    `upstream_response_time` UInt32,
    `x_forwarded_for` String CODEC(ZSTD(7)),
    `user_agent` String CODEC(ZSTD(7)),
    `x_request_id` String CODEC(ZSTD(7)),
    `request_id` String alias `x_request_id`,
    `x_real_ip` String CODEC(ZSTD(7)),
    `status` UInt16,
    `vhost` String CODEC(ZSTD(7)),
    `upstream_grpc_status` String CODEC(ZSTD(7)),
    `_lb_extra_server` LowCardinality(String) CODEC(ZSTD(7)),
    `_timestamp` DateTime CODEC(DoubleDelta, LZ4),
    `_partition` String CODEC(ZSTD(7)),
    `_topic` String CODEC(ZSTD(7)),
    `_offset` UInt64,
    `_idx` UInt32,
    `_rest` String CODEC(ZSTD(7))
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/logs_mail_api360_envoy_tskv_local', '{replica}')
PARTITION BY toYYYYMMDD(date)
ORDER BY (date, timestamp)
TTL date + toIntervalDay(7) DELETE, date + toIntervalDay(2) TO DISK 'object_storage'
SETTINGS ttl_only_drop_parts=1, index_granularity = 8192;



CREATE TABLE IF NOT EXISTS logs.api360_envoy_tskv ON CLUSTER 'active_logs' AS logs._mail_api360_envoy_tskv_local ENGINE = Distributed('active_logs', logs, _mail_api360_envoy_tskv_local, rand());
